/*
 * Decompiled with CFR 0.152.
 */
package com.btc.flowix.jbplugin.ui.validation;

import com.btc.flowix.jbplugin.TopLevelKt;
import com.btc.flowix.jbplugin.data.Field;
import com.btc.flowix.jbplugin.internal.PGType;
import com.btc.flowix.jbplugin.ui.validation.CommonAPIKt;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.layout.ValidationInfoBuilder;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.LongRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u001a\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u001a\u001c\u0010\t\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b\u001a\u001c\u0010\f\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004\u001a\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b\u001a$\u0010\t\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b\u001a\u008f\u0001\u0010\u0012\u001a\u00020\u0013\"\u0006\b\u0000\u0010\u0014\u0018\u00012\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u001626\u0010\u0017\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u0002H\u00140\u00182,\u0010\u001d\u001a(\u0012\u0004\u0012\u0002H\u0014\u0012\u0013\u0012\u0011H\u0014\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u00130\u0018\u00a2\u0006\u0002\b\u001fH\u0082\b\u001a\u001c\u0010 \u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b\u001a\u0014\u0010!\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\"\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010#\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010$\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&\u001a\u0014\u0010'\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010(\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010)\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010*\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010+\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006,"}, d2={"mustBeNotEmpty", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "value", "", "text", "mustBeInLongRange", "range", "Lkotlin/ranges/LongRange;", "mustBeValidSeq", "pgType", "Lcom/btc/flowix/jbplugin/internal/PGType;", "mustBeValidMinAndMax", "minValue", "maxValue", "mustBeValidTimeFormat", "min", "max", "validate", "", "T", "formatter", "Ljava/time/format/DateTimeFormatter;", "parseFunc", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "v", "f", "isAfterFunc", "other", "Lkotlin/ExtensionFunctionType;", "mustBeValidTimeList", "mustBeIntSeq", "mustBeFloatingSeq", "mustBeStringSeq", "mustBeValidFloatingStep", "field", "Lcom/btc/flowix/jbplugin/data/Field;", "mustBeIntArray", "mustBeFloatingArray", "mustBeIntRange", "mustBeNumRange", "mustBeUnsupportedVal", "flowixsql"})
@SourceDebugExtension(value={"SMAP\nValidation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Validation.kt\ncom/btc/flowix/jbplugin/ui/validation/ValidationKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,183:1\n98#1,3:184\n98#1,3:187\n98#1,3:190\n98#1,3:193\n98#1,3:196\n1#2:199\n1869#3,2:200\n*S KotlinDebug\n*F\n+ 1 Validation.kt\ncom/btc/flowix/jbplugin/ui/validation/ValidationKt\n*L\n69#1:184,3\n70#1:187,3\n71#1:190,3\n72#1:193,3\n73#1:196,3\n107#1:200,2\n*E\n"})
public final class ValidationKt {
    @Nullable
    public static final ValidationInfo mustBeNotEmpty(@NotNull ValidationInfoBuilder $this$mustBeNotEmpty, @NotNull String value, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)$this$mustBeNotEmpty, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return ((CharSequence)value).length() == 0 ? $this$mustBeNotEmpty.error(text) : null;
    }

    public static /* synthetic */ ValidationInfo mustBeNotEmpty$default(ValidationInfoBuilder validationInfoBuilder, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "Please specify a not empty value";
        }
        return ValidationKt.mustBeNotEmpty(validationInfoBuilder, string, string2);
    }

    @Nullable
    public static final ValidationInfo mustBeInLongRange(@NotNull ValidationInfoBuilder $this$mustBeInLongRange, @NotNull String value, @NotNull LongRange range) {
        Intrinsics.checkNotNullParameter((Object)$this$mustBeInLongRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return CommonAPIKt.errorIfFalse($this$mustBeInLongRange, "Please specify a valid number in range " + range, (Function0<Boolean>)((Function0)() -> ValidationKt.mustBeInLongRange$lambda$0(value, range)));
    }

    @Nullable
    public static final ValidationInfo mustBeValidSeq(@NotNull ValidationInfoBuilder $this$mustBeValidSeq, @NotNull String value, @NotNull PGType pgType) {
        Intrinsics.checkNotNullParameter((Object)$this$mustBeValidSeq, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)((Object)pgType), (String)"pgType");
        if (!CommonAPIKt.isIntNumber(value) && !CommonAPIKt.isFloatingNumber(value)) {
            return $this$mustBeValidSeq.error("Please specify a valid number");
        }
        Ref.ObjectRef range = new Ref.ObjectRef();
        return switch (WhenMappings.$EnumSwitchMapping$0[pgType.ordinal()]) {
            case 1, 2, 3, 4, 5, 6, 7, 8 -> {
                range.element = pgType.asIntJvmRange();
                yield CommonAPIKt.errorIfFalse($this$mustBeValidSeq, "Please specify a valid number in range " + range.element, (Function0<Boolean>)((Function0)() -> ValidationKt.mustBeValidSeq$lambda$0(range, value)));
            }
            case 9, 10, 11, 12 -> {
                range.element = pgType.asFloatingJvmRange();
                yield CommonAPIKt.errorIfFalse($this$mustBeValidSeq, "Please specify a valid number in range " + range.element, (Function0<Boolean>)((Function0)() -> ValidationKt.mustBeValidSeq$lambda$1(range, value)));
            }
            case 13, 14, 15 -> null;
            default -> {
                TopLevelKt.errPgType();
                throw new KotlinNothingValueException();
            }
        };
    }

    @Nullable
    public static final ValidationInfo mustBeValidMinAndMax(@NotNull ValidationInfoBuilder $this$mustBeValidMinAndMax, @NotNull String minValue, @NotNull String maxValue) {
        Intrinsics.checkNotNullParameter((Object)$this$mustBeValidMinAndMax, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)minValue, (String)"minValue");
        Intrinsics.checkNotNullParameter((Object)maxValue, (String)"maxValue");
        Function0 intOutOfRange = () -> ValidationKt.mustBeValidMinAndMax$lambda$0(minValue, maxValue);
        Function0 floatOutOfRange = () -> ValidationKt.mustBeValidMinAndMax$lambda$1(minValue, maxValue);
        return CommonAPIKt.errorIfTrue($this$mustBeValidMinAndMax, "Min value must be equal or less than Max", (Function0<Boolean>)((Function0)() -> ValidationKt.mustBeValidMinAndMax$lambda$2(intOutOfRange, floatOutOfRange)));
    }

    @Nullable
    public static final ValidationInfo mustBeValidTimeFormat(@NotNull ValidationInfoBuilder $this$mustBeValidTimeFormat, @NotNull String value, @NotNull PGType pgType) {
        Intrinsics.checkNotNullParameter((Object)$this$mustBeValidTimeFormat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)((Object)pgType), (String)"pgType");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pgType.defaultFormat());
        return CommonAPIKt.errorIfThrow($this$mustBeValidTimeFormat, "Only this format is accepted: " + pgType.defaultFormat(), (Function0<Unit>)((Function0)() -> ValidationKt.mustBeValidTimeFormat$lambda$0(pgType, value, formatter, $this$mustBeValidTimeFormat)));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public static final ValidationInfo mustBeValidSeq(@NotNull ValidationInfoBuilder $this$mustBeValidSeq, @NotNull String min, @NotNull String max, @NotNull PGType pgType) {
        Intrinsics.checkNotNullParameter((Object)$this$mustBeValidSeq, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        Intrinsics.checkNotNullParameter((Object)pgType, (String)"pgType");
        formatter = DateTimeFormatter.ofPattern(pgType.defaultFormat());
        var5_5 = $this$mustBeValidSeq;
        try {
            block14: {
                block13: {
                    $this$mustBeValidSeq_u24lambda_u242 /* !! */  = var5_5;
                    $i$a$-runCatching-ValidationKt$mustBeValidSeq$3 = false;
                    switch (WhenMappings.$EnumSwitchMapping$0[pgType.ordinal()]) {
                        case 16: {
                            var8_9 = min;
                            var9_10 = max;
                            Intrinsics.checkNotNull((Object)formatter);
                            formatter$iv = formatter;
                            $i$f$validate = false;
                            var12_13 = formatter$iv;
                            p0 = min$iv;
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$1 = false;
                            minT$iv = LocalDate.parse(p0, (DateTimeFormatter)p1);
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$1 = formatter$iv;
                            p0 = max$iv;
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$1 = false;
                            maxT$iv = LocalDate.parse(p0, (DateTimeFormatter)p1);
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$1 = (ChronoLocalDate)maxT$iv;
                            p0 = minT$iv;
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$2 = false;
                            v0 = p0.isAfter((ChronoLocalDate)p1);
                            break;
                        }
                        case 17: {
                            min$iv = min;
                            max$iv = max;
                            Intrinsics.checkNotNull((Object)formatter);
                            formatter$iv = formatter;
                            $i$f$validate = false;
                            maxT$iv = formatter$iv;
                            p0 = min$iv;
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$3 = false;
                            minT$iv = LocalTime.parse(p0, (DateTimeFormatter)p1);
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$3 = formatter$iv;
                            p0 = max$iv;
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$3 = false;
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$3 = maxT$iv = LocalTime.parse(p0, (DateTimeFormatter)p1);
                            p0 = minT$iv;
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$4 = false;
                            v0 = p0.isAfter((LocalTime)p1);
                            break;
                        }
                        case 18: {
                            min$iv = min;
                            max$iv = max;
                            Intrinsics.checkNotNull((Object)formatter);
                            formatter$iv = formatter;
                            $i$f$validate = false;
                            maxT$iv = formatter$iv;
                            p0 = min$iv;
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$5 = false;
                            minT$iv = OffsetTime.parse(p0, (DateTimeFormatter)p1);
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$5 = formatter$iv;
                            p0 = max$iv;
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$5 = false;
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$5 = maxT$iv = OffsetTime.parse(p0, (DateTimeFormatter)p1);
                            p0 = minT$iv;
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$6 = false;
                            v0 = p0.isAfter((OffsetTime)p1);
                            break;
                        }
                        case 19: {
                            min$iv = min;
                            max$iv = max;
                            Intrinsics.checkNotNull((Object)formatter);
                            formatter$iv = formatter;
                            $i$f$validate = false;
                            maxT$iv = formatter$iv;
                            p0 = min$iv;
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$7 = false;
                            minT$iv = LocalDateTime.parse(p0, (DateTimeFormatter)p1);
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$7 = formatter$iv;
                            p0 = max$iv;
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$7 = false;
                            maxT$iv = LocalDateTime.parse(p0, (DateTimeFormatter)p1);
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$7 = (ChronoLocalDateTime)maxT$iv;
                            p0 = minT$iv;
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$8 = false;
                            v0 = p0.isAfter((ChronoLocalDateTime<?>)p1);
                            break;
                        }
                        case 20: {
                            min$iv = min;
                            max$iv = max;
                            Intrinsics.checkNotNull((Object)formatter);
                            formatter$iv = formatter;
                            $i$f$validate = false;
                            maxT$iv = formatter$iv;
                            p0 = min$iv;
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$9 = false;
                            minT$iv = OffsetDateTime.parse(p0, (DateTimeFormatter)p1);
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$9 = formatter$iv;
                            p0 = max$iv;
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$9 = false;
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$9 = maxT$iv = OffsetDateTime.parse(p0, (DateTimeFormatter)p1);
                            p0 = minT$iv;
                            $i$a$-validate-ValidationKt$mustBeValidSeq$3$inValid$10 = false;
                            v0 = p0.isAfter((OffsetDateTime)p1);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Wrong pg type".toString());
                        }
                    }
                    inValid = v0;
                    if (!inValid) break block13;
                    v1 = $this$mustBeValidSeq_u24lambda_u242 /* !! */ .error("Min must be less than Max");
                    break block14;
                }
                var18_29 = new PGType[]{PGType.TIMETZ, PGType.TIMESTAMPTZ};
                if (!SetsKt.setOf((Object[])var18_29).contains((Object)pgType)) ** GOTO lbl-1000
                v2 = min.substring(min.length() - 6);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"substring(...)");
                v3 = max.substring(max.length() - 6);
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"substring(...)");
                if (!Intrinsics.areEqual((Object)v2, (Object)v3)) {
                    v1 = $this$mustBeValidSeq_u24lambda_u242 /* !! */ .error("Timezone values must be identical");
                } else lbl-1000:
                // 2 sources

                {
                    v1 = null;
                }
            }
            $this$mustBeValidSeq_u24lambda_u242 /* !! */  = Result.constructor-impl((Object)v1);
        }
        catch (Throwable $i$a$-runCatching-ValidationKt$mustBeValidSeq$3) {
            $this$mustBeValidSeq_u24lambda_u242 /* !! */  = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-ValidationKt$mustBeValidSeq$3));
        }
        var5_5 = $this$mustBeValidSeq_u24lambda_u242 /* !! */ ;
        v4 = Result.exceptionOrNull-impl((Object)var5_5);
        if (v4 == null) {
            v5 = var5_5;
        } else {
            it = v4;
            $i$a$-getOrElse-ValidationKt$mustBeValidSeq$4 = false;
            v5 = $this$mustBeValidSeq.error("Only this format is accepted: " + pgType.defaultFormat());
        }
        return (ValidationInfo)v5;
    }

    private static final /* synthetic */ <T> boolean validate(String min, String max, DateTimeFormatter formatter, Function2<? super String, ? super DateTimeFormatter, ? extends T> parseFunc, Function2<? super T, ? super T, Boolean> isAfterFunc) {
        boolean $i$f$validate = false;
        Object minT = parseFunc.invoke((Object)min, (Object)formatter);
        Object maxT = parseFunc.invoke((Object)max, (Object)formatter);
        return (Boolean)isAfterFunc.invoke(minT, maxT);
    }

    @Nullable
    public static final ValidationInfo mustBeValidTimeList(@NotNull ValidationInfoBuilder $this$mustBeValidTimeList, @NotNull String value, @NotNull PGType pgType) {
        Intrinsics.checkNotNullParameter((Object)$this$mustBeValidTimeList, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)((Object)pgType), (String)"pgType");
        CharSequence charSequence = value;
        Regex regex = new Regex("\\s?,\\s?");
        int n = 0;
        List dates = regex.split(charSequence, n);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pgType.defaultFormat());
        return CommonAPIKt.errorIfThrow($this$mustBeValidTimeList, "Please specify a valid date/time list: " + pgType.defaultFormat() + ", ...", (Function0<Unit>)((Function0)() -> ValidationKt.mustBeValidTimeList$lambda$0(dates, pgType, formatter)));
    }

    @Nullable
    public static final ValidationInfo mustBeIntSeq(@NotNull ValidationInfoBuilder $this$mustBeIntSeq, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$mustBeIntSeq, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return CommonAPIKt.errorIfFalse($this$mustBeIntSeq, "Please specify a valid comma-separated list of numbers: 1,2,100...", (Function0<Boolean>)((Function0)() -> ValidationKt.mustBeIntSeq$lambda$0(value)));
    }

    @Nullable
    public static final ValidationInfo mustBeFloatingSeq(@NotNull ValidationInfoBuilder $this$mustBeFloatingSeq, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$mustBeFloatingSeq, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return CommonAPIKt.errorIfFalse($this$mustBeFloatingSeq, "Please specify a valid comma-separated list of numbers: 0.1,2.3,...", (Function0<Boolean>)((Function0)() -> ValidationKt.mustBeFloatingSeq$lambda$0(value)));
    }

    @Nullable
    public static final ValidationInfo mustBeStringSeq(@NotNull ValidationInfoBuilder $this$mustBeStringSeq, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$mustBeStringSeq, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return CommonAPIKt.errorIfFalse($this$mustBeStringSeq, "Please specify a valid comma-separated list of strings: val1,val2...", (Function0<Boolean>)((Function0)() -> ValidationKt.mustBeStringSeq$lambda$0(value)));
    }

    @Nullable
    public static final ValidationInfo mustBeValidFloatingStep(@NotNull ValidationInfoBuilder $this$mustBeValidFloatingStep, @NotNull String value, @NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)$this$mustBeValidFloatingStep, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        String defaultMax = field.pgType().defaultMax(field);
        String errMsg = "Please specify a valid positive number less or equal then " + defaultMax;
        PGType pgType = field.pgType();
        return CommonAPIKt.errorIfTrue($this$mustBeValidFloatingStep, errMsg, (Function0<Boolean>)((Function0)() -> ValidationKt.mustBeValidFloatingStep$lambda$0(value, defaultMax, pgType, field)));
    }

    @Nullable
    public static final ValidationInfo mustBeIntArray(@NotNull ValidationInfoBuilder $this$mustBeIntArray, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$mustBeIntArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return CommonAPIKt.errorIfFalse($this$mustBeIntArray, "Please specify a valid comma-separated list of arrays: {1},{1,2,3},{}...", (Function0<Boolean>)((Function0)() -> ValidationKt.mustBeIntArray$lambda$0(value)));
    }

    @Nullable
    public static final ValidationInfo mustBeFloatingArray(@NotNull ValidationInfoBuilder $this$mustBeFloatingArray, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$mustBeFloatingArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return CommonAPIKt.errorIfFalse($this$mustBeFloatingArray, "Please specify a valid comma-separated list of arrays: {1,1.1},{1.23,2.12,3.2123},{}...", (Function0<Boolean>)((Function0)() -> ValidationKt.mustBeFloatingArray$lambda$0(value)));
    }

    @Nullable
    public static final ValidationInfo mustBeIntRange(@NotNull ValidationInfoBuilder $this$mustBeIntRange, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$mustBeIntRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return CommonAPIKt.errorIfFalse($this$mustBeIntRange, "Please specify a valid comma-separated list of ranges: [1,2],(-11,0],[,]...", (Function0<Boolean>)((Function0)() -> ValidationKt.mustBeIntRange$lambda$0(value)));
    }

    @Nullable
    public static final ValidationInfo mustBeNumRange(@NotNull ValidationInfoBuilder $this$mustBeNumRange, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$mustBeNumRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return CommonAPIKt.errorIfFalse($this$mustBeNumRange, "Please specify a valid comma-separated list of ranges: [1.23,2],(-11.23,0.33],[,]...", (Function0<Boolean>)((Function0)() -> ValidationKt.mustBeNumRange$lambda$0(value)));
    }

    @Nullable
    public static final ValidationInfo mustBeUnsupportedVal(@NotNull ValidationInfoBuilder $this$mustBeUnsupportedVal, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$mustBeUnsupportedVal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return CommonAPIKt.errorIfFalse($this$mustBeUnsupportedVal, "\u26a0\ufe0f This type is currently not fully supported. Using it may cause unexpected behavior. You can input values in the appropriate format at your own risk. Wrap values with double quotes \"val1\", \"val2\" ...", (Function0<Boolean>)((Function0)() -> ValidationKt.mustBeUnsupportedVal$lambda$0(value)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean mustBeInLongRange$lambda$0(String $value, LongRange $range) {
        if (!CommonAPIKt.isIntNumber($value)) return false;
        long l = $range.getFirst();
        long l2 = $range.getLast();
        long l3 = Long.parseLong($value);
        if (l > l3) return false;
        if (l3 > l2) return false;
        return true;
    }

    private static final boolean mustBeValidSeq$lambda$0(Ref.ObjectRef $range, String $value) {
        return ((LongRange)$range.element).contains(Long.parseLong($value));
    }

    private static final boolean mustBeValidSeq$lambda$1(Ref.ObjectRef $range, String $value) {
        return ((ClosedFloatingPointRange)$range.element).contains((Comparable)Double.valueOf(Double.parseDouble($value)));
    }

    private static final boolean mustBeValidMinAndMax$lambda$0(String $minValue, String $maxValue) {
        return CommonAPIKt.isIntNumber($minValue) && CommonAPIKt.isIntNumber($maxValue) && Long.parseLong($minValue) > Long.parseLong($maxValue);
    }

    private static final boolean mustBeValidMinAndMax$lambda$1(String $minValue, String $maxValue) {
        return CommonAPIKt.isFloatingNumber($minValue) && CommonAPIKt.isFloatingNumber($maxValue) && Double.parseDouble($minValue) > Double.parseDouble($maxValue);
    }

    private static final boolean mustBeValidMinAndMax$lambda$2(Function0 $intOutOfRange, Function0 $floatOutOfRange) {
        return (Boolean)$intOutOfRange.invoke() != false || (Boolean)$floatOutOfRange.invoke() != false;
    }

    private static final Unit mustBeValidTimeFormat$lambda$0(PGType $pgType, String $value, DateTimeFormatter $formatter, ValidationInfoBuilder $this_mustBeValidTimeFormat) {
        switch (WhenMappings.$EnumSwitchMapping$0[$pgType.ordinal()]) {
            case 16: {
                Object object = LocalDate.parse($value, $formatter);
                break;
            }
            case 17: {
                Object object = LocalTime.parse($value, $formatter);
                break;
            }
            case 18: {
                Object object = OffsetTime.parse($value, $formatter);
                break;
            }
            case 19: {
                Object object = LocalDateTime.parse($value, $formatter);
                break;
            }
            case 20: {
                Object object = OffsetDateTime.parse($value, $formatter);
                break;
            }
            default: {
                Object object = $this_mustBeValidTimeFormat.error("Wrong pg type");
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit mustBeValidTimeList$lambda$0(List $dates, PGType $pgType, DateTimeFormatter $formatter) {
        Iterable $this$forEach$iv = $dates;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[$pgType.ordinal()]) {
                case 16: {
                    Comparable<ChronoLocalDate> comparable = LocalDate.parse(it, $formatter);
                    break;
                }
                case 17: {
                    Comparable<ChronoLocalDate> comparable = LocalTime.parse(it, $formatter);
                    break;
                }
                case 18: {
                    Comparable<ChronoLocalDate> comparable = OffsetTime.parse(it, $formatter);
                    break;
                }
                case 19: {
                    Comparable<ChronoLocalDate> comparable = LocalDateTime.parse(it, $formatter);
                    break;
                }
                case 20: {
                    Comparable<ChronoLocalDate> comparable = OffsetDateTime.parse(it, $formatter);
                    break;
                }
                default: {
                    TopLevelKt.errPgType();
                    throw new KotlinNothingValueException();
                }
            }
        }
        return Unit.INSTANCE;
    }

    private static final boolean mustBeIntSeq$lambda$0(String $value) {
        CharSequence charSequence = $value;
        return new Regex("-?\\d+(\\s?,\\s?-?\\d+)*").matches(charSequence);
    }

    private static final boolean mustBeFloatingSeq$lambda$0(String $value) {
        CharSequence charSequence = $value;
        return new Regex("-?\\d+(\\.-?\\d+)?(\\s?,\\s?-?\\d+(\\.-?\\d+)?)*").matches(charSequence);
    }

    private static final boolean mustBeStringSeq$lambda$0(String $value) {
        CharSequence charSequence = $value;
        return new Regex("^\\s*\\w+(?:\\s*,\\s*\\w+)*\\s*$").matches(charSequence);
    }

    private static final boolean mustBeValidFloatingStep$lambda$0(String $value, String $defaultMax, PGType $pgType, Field $field) {
        boolean bl;
        if (CommonAPIKt.isFloatingNumber($value)) {
            boolean outOfScale;
            boolean moreThenMax;
            boolean negative = new BigDecimal($value).signum() <= 0;
            boolean bl2 = moreThenMax = new BigDecimal($value).compareTo(new BigDecimal($defaultMax)) > 0;
            boolean bl3 = $pgType == PGType.NUMERIC && !$field.unconstrained() ? new BigDecimal($value).precision() > $field.getPrecision() || new BigDecimal($value).scale() > $field.getScale() : (outOfScale = false);
            bl = negative || moreThenMax || outOfScale;
        } else {
            bl = true;
        }
        return bl;
    }

    private static final boolean mustBeIntArray$lambda$0(String $value) {
        CharSequence charSequence = $value;
        return new Regex("\\{-?\\d*(\\s?,\\s?-?\\d+)*}\\s?(,\\s?\\{-?\\d*(\\s?,\\s?-?\\d+)*})*").matches(charSequence);
    }

    private static final boolean mustBeFloatingArray$lambda$0(String $value) {
        CharSequence charSequence = $value;
        return new Regex("\\{-?\\d*(\\.\\d+)?(\\s?,\\s?-?\\d+(\\.\\d+)?)*}\\s?(,\\s?\\{-?\\d*(\\.\\d+)?((\\s?,\\s?-?\\d+(\\.\\d})?)*})*)*").matches(charSequence);
    }

    private static final boolean mustBeIntRange$lambda$0(String $value) {
        CharSequence charSequence = $value;
        return new Regex("[(\\[](-?\\d+)?,(-?\\d+)?[)\\]]\\s?(,\\s?[(\\[](-?\\d+)?,(-?\\d+)?[)\\]])*").matches(charSequence);
    }

    private static final boolean mustBeNumRange$lambda$0(String $value) {
        CharSequence charSequence = $value;
        return new Regex("[(\\[](-?\\d+(\\.\\d+)?)?,(-?\\d+(\\.\\d+)?)?[)\\]]\\s?(,\\s?[(\\[](-?\\d+(\\.\\d+)?)?,(-?\\d+(\\.\\d+)?)?[)\\]])*").matches(charSequence);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean mustBeUnsupportedVal$lambda$0(String $value) {
        if (((CharSequence)$value).length() == 0) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        CharSequence charSequence = $value;
        if (!new Regex(((Object)StringsKt.trim((CharSequence)" \"[^\"]+\"(\\s?,\\s?\"[^\"]+\")* ")).toString()).matches(charSequence)) return false;
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PGType.values().length];
            try {
                nArray[PGType.SMALLINT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PGType.INTEGER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PGType.BIGINT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PGType.SMALLINT_ARRAY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PGType.INTEGER_ARRAY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PGType.BIGINT_ARRAY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PGType.INT4RANGE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PGType.INT8RANGE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PGType.REAL.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PGType.DOUBLE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PGType.REAL_ARRAY.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PGType.DOUBLE_ARRAY.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PGType.NUMERIC.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PGType.NUMERIC_ARRAY.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PGType.NUMRANGE.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PGType.DATE.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PGType.TIME.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PGType.TIMETZ.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PGType.TIMESTAMP.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PGType.TIMESTAMPTZ.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

