/*
 * Decompiled with CFR 0.152.
 */
package com.btc.flowix.jbplugin.services;

import com.btc.flowix.jbplugin.IJLogger;
import com.btc.flowix.jbplugin.LoggerFacade;
import com.btc.flowix.jbplugin.SoutLogger;
import com.btc.flowix.jbplugin.TopLevelKt;
import com.btc.flowix.jbplugin.data.Mock;
import com.btc.flowix.jbplugin.data.MockFolder;
import com.btc.flowix.jbplugin.data.MockState;
import com.btc.flowix.jbplugin.data.TreeObject;
import com.btc.flowix.jbplugin.data.serialization.FileAccessor;
import com.btc.flowix.jbplugin.data.serialization.JacksonSerializer;
import com.btc.flowix.jbplugin.data.serialization.MockDeserializer;
import com.btc.flowix.jbplugin.data.serialization.NioFileAccessor;
import com.btc.flowix.jbplugin.data.serialization.RawReader;
import com.btc.flowix.jbplugin.data.serialization.Serializer;
import com.btc.flowix.jbplugin.data.serialization.SnakeYamlReader;
import com.btc.flowix.jbplugin.services.MockService;
import com.btc.flowix.jbplugin.ui.mockstree.TreeElement;
import com.fasterxml.jackson.core.type.TypeReference;
import com.intellij.openapi.application.ApplicationManager;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J \u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001a\u0010 \u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00162\b\u0010!\u001a\u0004\u0018\u00010\u001dH\u0016J \u0010\"\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u001dH\u0016J \u0010#\u001a\b\u0012\u0004\u0012\u00020\b0$2\u0006\u0010\u001b\u001a\u00020\u00162\b\u0010%\u001a\u0004\u0018\u00010\u001dH\u0002J\"\u0010&\u001a\u00020\u0012*\u00020\u001d2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\b0$2\u0006\u0010(\u001a\u00020\u0016H\u0002J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\b0*2\u0006\u0010+\u001a\u00020\u0014H\u0002J\u0016\u0010,\u001a\u00020\u00122\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\b0*H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\bH\u0016J\u0010\u00101\u001a\u00020\b2\u0006\u00102\u001a\u00020\u0014H\u0016J\u0018\u00103\u001a\u00020\u00142\u0006\u00104\u001a\u00020\u00142\u0006\u00102\u001a\u00020\u0014H\u0016J\u0010\u00105\u001a\u00020\u00122\u0006\u00106\u001a\u00020\u0014H\u0016J8\u00107\u001a\u00020\u0012*\u00020\u00162\u0014\b\u0002\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020\u0012092\u0014\b\u0002\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001209H\u0002J&\u0010<\u001a\b\u0012\u0004\u0012\u00020:0**\u00020\u00162\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020\u001909H\u0002J&\u0010>\u001a\b\u0012\u0004\u0012\u00020\b0**\u00020\u00162\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001909H\u0002J\u0010\u0010?\u001a\u00020\u00142\u0006\u0010@\u001a\u00020AH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/btc/flowix/jbplugin/services/MockServiceImpl;", "Lcom/btc/flowix/jbplugin/services/MockService;", "fileAccessor", "Lcom/btc/flowix/jbplugin/data/serialization/FileAccessor;", "<init>", "(Lcom/btc/flowix/jbplugin/data/serialization/FileAccessor;)V", "mocks", "", "Lcom/btc/flowix/jbplugin/data/Mock;", "nioFileAccessor", "Lcom/btc/flowix/jbplugin/data/serialization/NioFileAccessor;", "yamlReader", "Lcom/btc/flowix/jbplugin/data/serialization/RawReader;", "yamlSerializer", "Lcom/btc/flowix/jbplugin/data/serialization/Serializer;", "log", "Lcom/btc/flowix/jbplugin/LoggerFacade;", "updateLoadedMocks", "", "message", "", "node", "Lcom/btc/flowix/jbplugin/ui/mockstree/TreeElement;", "switchState", "enabled", "", "loadMocks", "root", "mockDirectory", "Ljava/io/File;", "loadMocksIfRequired", "changedFile", "loadTraces", "logDirectory", "loadTracesIfRequired", "fillTree", "", "dir", "scan", "loaded", "treeNode", "loadMock", "", "path", "saveMocks", "inputMocks", "deleteMock", "Lcom/btc/flowix/jbplugin/services/MockService$DeletingResult;", "mock", "newMock", "nodePath", "newMockDir", "parentPath", "removeMockDir", "mockPath", "walk", "folderRun", "Lkotlin/Function1;", "Lcom/btc/flowix/jbplugin/data/MockFolder;", "mockRun", "collectFolders", "predicate", "collectMocks", "getMockPath", "mockId", "Ljava/util/UUID;", "flowixsql"})
@SourceDebugExtension(value={"SMAP\nMockServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockServiceImpl.kt\ncom/btc/flowix/jbplugin/services/MockServiceImpl\n+ 2 TopLevel.kt\ncom/btc/flowix/jbplugin/TopLevelKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,244:1\n79#2,5:245\n1869#3,2:250\n1491#3:256\n1516#3,3:257\n1519#3,3:267\n774#3:271\n865#3,2:272\n1563#3:274\n1634#3,3:275\n774#3:279\n865#3,2:280\n1869#3,2:282\n1869#3,2:284\n1869#3,2:286\n1761#3,3:289\n1761#3,3:292\n1761#3,3:295\n13472#4,2:252\n13472#4,2:254\n382#5,7:260\n216#6:270\n217#6:278\n1#7:288\n*S KotlinDebug\n*F\n+ 1 MockServiceImpl.kt\ncom/btc/flowix/jbplugin/services/MockServiceImpl\n*L\n30#1:245,5\n51#1:250,2\n143#1:256\n143#1:257,3\n143#1:267,3\n149#1:271\n149#1:272,2\n157#1:274\n157#1:275,3\n169#1:279\n169#1:280,2\n209#1:282,2\n220#1:284,2\n232#1:286,2\n77#1:289,3\n82#1:292,3\n152#1:295,3\n112#1:252,2\n124#1:254,2\n143#1:260,7\n144#1:270\n144#1:278\n*E\n"})
public final class MockServiceImpl
implements MockService {
    @NotNull
    private final FileAccessor fileAccessor;
    @NotNull
    private final List<Mock> mocks;
    @NotNull
    private final NioFileAccessor nioFileAccessor;
    @NotNull
    private final RawReader yamlReader;
    @NotNull
    private final Serializer yamlSerializer;
    @NotNull
    private final LoggerFacade log;

    public MockServiceImpl(@NotNull FileAccessor fileAccessor) {
        Intrinsics.checkNotNullParameter((Object)fileAccessor, (String)"fileAccessor");
        this.fileAccessor = fileAccessor;
        this.mocks = new ArrayList();
        this.nioFileAccessor = new NioFileAccessor();
        this.yamlReader = new SnakeYamlReader(this.fileAccessor);
        this.yamlSerializer = JacksonSerializer.Companion.yamlSerializer(this.nioFileAccessor);
        MockServiceImpl $this$getLogger$iv = this;
        boolean $i$f$getLogger = false;
        this.log = ApplicationManager.getApplication() != null ? (LoggerFacade)new IJLogger(MockServiceImpl.class) : (LoggerFacade)new SoutLogger(MockServiceImpl.class);
    }

    @Override
    public void updateLoadedMocks(@NotNull String message, @NotNull TreeElement node) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Map loaded2 = (Map)TopLevelKt.deserializeJson(message, (TypeReference)new TypeReference<Map<UUID, ? extends Boolean>>(){});
        MockServiceImpl.walk$default(this, node, null, arg_0 -> MockServiceImpl.updateLoadedMocks$lambda$0(loaded2, arg_0), 1, null);
    }

    @Override
    public void switchState(@NotNull TreeElement node, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        TreeObject ob = node.getObj();
        if (ob instanceof MockFolder) {
            ((MockFolder)ob).setEnabled(enabled);
            Iterable $this$forEach$iv = node.getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TreeElement it = (TreeElement)element$iv;
                boolean bl = false;
                this.switchState(it, enabled);
            }
        } else if (ob instanceof Mock) {
            ((Mock)ob).setState(enabled ? MockState.ON_FLY : MockState.DISABLED);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    public void loadMocks(@NotNull TreeElement root, @Nullable File mockDirectory) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        File file = mockDirectory;
        Intrinsics.checkNotNull((Object)file);
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        root.setObj(new MockFolder(string, "", true));
        this.mocks.clear();
        this.mocks.addAll((Collection<Mock>)this.fillTree(root, mockDirectory));
    }

    @Override
    public void loadMocksIfRequired(@NotNull String changedFile, @NotNull TreeElement root, @NotNull File mockDirectory) {
        Intrinsics.checkNotNullParameter((Object)changedFile, (String)"changedFile");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)mockDirectory, (String)"mockDirectory");
        Path a = Paths.get(changedFile, new String[0]).normalize();
        Path b = Paths.get(mockDirectory.getPath(), new String[0]).normalize();
        if (a.startsWith(b)) {
            List<MockFolder> disabledFolders = this.collectFolders(root, (Function1<? super MockFolder, Boolean>)((Function1)MockServiceImpl::loadMocksIfRequired$lambda$0));
            List<Mock> disabledMocks = this.collectMocks(root, (Function1<? super Mock, Boolean>)((Function1)MockServiceImpl::loadMocksIfRequired$lambda$1));
            this.mocks.clear();
            this.mocks.addAll((Collection<Mock>)this.fillTree(root, mockDirectory));
            this.walk(root, (Function1<? super MockFolder, Unit>)((Function1)arg_0 -> MockServiceImpl.loadMocksIfRequired$lambda$2(disabledFolders, arg_0)), (Function1<? super Mock, Unit>)((Function1)arg_0 -> MockServiceImpl.loadMocksIfRequired$lambda$3(disabledMocks, this, arg_0)));
        }
    }

    @Override
    public void loadTraces(@NotNull TreeElement root, @Nullable File logDirectory) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        File file = logDirectory;
        Intrinsics.checkNotNull((Object)file);
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        root.setObj(new MockFolder(string, "", true));
        this.fillTree(root, logDirectory);
    }

    @Override
    public void loadTracesIfRequired(@NotNull String changedFile, @NotNull TreeElement root, @NotNull File logDirectory) {
        Intrinsics.checkNotNullParameter((Object)changedFile, (String)"changedFile");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)logDirectory, (String)"logDirectory");
        Path a = Paths.get(changedFile, new String[0]).normalize();
        Path b = Paths.get(logDirectory.getPath(), new String[0]).normalize();
        if (a.startsWith(b)) {
            this.fillTree(root, logDirectory);
        }
    }

    private final Set<Mock> fillTree(TreeElement root, File dir) {
        Set loaded2;
        block2: {
            if (dir == null) {
                return new LinkedHashSet();
            }
            root.getChildren().clear();
            loaded2 = new LinkedHashSet();
            File[] fileArray = dir.listFiles();
            if (fileArray == null) break block2;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                this.scan(it, loaded2, root);
            }
        }
        return loaded2;
    }

    private final void scan(File $this$scan, Set<Mock> loaded2, TreeElement treeNode) {
        block5: {
            block4: {
                if (!$this$scan.exists()) {
                    return;
                }
                if (!$this$scan.isDirectory()) break block4;
                TreeObject treeObject = treeNode.getObj();
                Intrinsics.checkNotNull((Object)treeObject, (String)"null cannot be cast to non-null type com.btc.flowix.jbplugin.data.MockFolder");
                String newRP = ((MockFolder)treeObject).getPath() + "/" + $this$scan.getName();
                String string = $this$scan.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                TreeElement newNode = new TreeElement(new MockFolder(string, newRP, true), null, 2, null);
                treeNode.getChildren().add(newNode);
                File[] fileArray = $this$scan.listFiles();
                if (fileArray == null) break block5;
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File it = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    this.scan(it, loaded2, newNode);
                }
                break block5;
            }
            if (StringsKt.equals((String)FilesKt.getExtension((File)$this$scan), (String)"yaml", (boolean)true)) {
                String string = $this$scan.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                List<Mock> list = this.loadMock(string);
                loaded2.addAll((Collection<Mock>)list);
                for (Mock item : list) {
                    TreeElement treeNode2 = new TreeElement(item, null, 2, null);
                    treeNode.getChildren().add(treeNode2);
                }
            }
        }
    }

    private final List<Mock> loadMock(String path) {
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path file = path2;
        return new MockDeserializer(this.yamlReader).parse(file);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveMocks(@NotNull List<Mock> inputMocks) {
        Map mocksByFiles;
        Object value$iv$iv$iv;
        Iterable<Path> key$iv$iv;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(inputMocks, (String)"inputMocks");
        Iterable $this$groupBy$iv = inputMocks;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            Mock it = (Mock)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getFullMockPath();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$forEach$iv = mocksByFiles = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Map.Entry element$iv;
            Object element$iv$iv;
            Map.Entry pathAndMocks = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            Object $this$saveMocks_u24lambda_u241_u240 = element$iv$iv = CollectionsKt.createListBuilder();
            boolean $i$a$-buildList-MockServiceImpl$saveMocks$1$forSerializing$22 = false;
            key$iv$iv = this.mocks;
            Object $this$getOrPut$iv$iv$iv = $this$saveMocks_u24lambda_u241_u240;
            boolean $i$f$filter = false;
            value$iv$iv$iv = $this$filter$iv;
            Object destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                Mock m = (Mock)element$iv$iv2;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)m.getFullMockPath(), pathAndMocks.getKey())) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$getOrPut$iv$iv$iv.addAll((List)destination$iv$iv2);
            $this$saveMocks_u24lambda_u241_u240.removeIf(arg_0 -> MockServiceImpl.saveMocks$lambda$1$0$2(arg_0 -> MockServiceImpl.saveMocks$lambda$1$0$1(pathAndMocks, arg_0), arg_0));
            $this$saveMocks_u24lambda_u241_u240.addAll((Collection)pathAndMocks.getValue());
            List forSerializing = CollectionsKt.build((List)element$iv$iv);
            this.yamlSerializer.serialize(forSerializing, (Path)pathAndMocks.getKey());
            element$iv$iv = (Iterable)pathAndMocks.getValue();
            LoggerFacade loggerFacade = this.log;
            boolean $i$f$map = false;
            void $i$a$-buildList-MockServiceImpl$saveMocks$1$forSerializing$22 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                destination$iv$iv2 = (Mock)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl4 = false;
                collection.add(it.getId());
            }
            loggerFacade.info("Saved: " + (List)destination$iv$iv3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MockService.DeletingResult deleteMock(@NotNull Mock mock) {
        MockService.DeletingResult deletingResult;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mock, (String)"mock");
        Iterable $this$filter$iv = this.mocks;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Mock m = (Mock)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)m.getMockPath(), (Object)mock.getMockPath()) && Intrinsics.areEqual((Object)m.getMockFileName(), (Object)mock.getMockFileName()) && m != mock)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List mocksFromCurrentFile = (List)destination$iv$iv;
        this.mocks.remove(mock);
        if (mocksFromCurrentFile.isEmpty()) {
            Files.delete(mock.getFullMockPath());
            deletingResult = MockService.DeletingResult.FILE_DELETED;
        } else {
            this.yamlSerializer.serialize(mocksFromCurrentFile, mock.getFullMockPath());
            deletingResult = MockService.DeletingResult.FILE_SAVED;
        }
        return deletingResult;
    }

    @Override
    @NotNull
    public Mock newMock(@NotNull String nodePath) {
        Intrinsics.checkNotNullParameter((Object)nodePath, (String)"nodePath");
        String fileName = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss")) + ".yaml";
        Path mockPath = this.nioFileAccessor.createFile(nodePath, fileName);
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        UUID uUID2 = uUID;
        String string = ((Object)mockPath.getParent()).toString();
        MockState mockState = MockState.ON_FLY;
        Mock mock = new Mock(uUID2, "", "<empty>", null, "SELECT 0", null, null, "", string, fileName, mockState, 104, null);
        this.mocks.add(mock);
        this.log.info("Created mock: " + mock.getId());
        this.saveMocks(CollectionsKt.listOf((Object)mock));
        return mock;
    }

    @Override
    @NotNull
    public String newMockDir(@NotNull String parentPath, @NotNull String nodePath) {
        Intrinsics.checkNotNullParameter((Object)parentPath, (String)"parentPath");
        Intrinsics.checkNotNullParameter((Object)nodePath, (String)"nodePath");
        return ((Object)this.fileAccessor.createDirs(parentPath + "/" + nodePath)).toString();
    }

    @Override
    public void removeMockDir(@NotNull String mockPath) {
        Intrinsics.checkNotNullParameter((Object)mockPath, (String)"mockPath");
        this.nioFileAccessor.removeDirsWithContent(mockPath);
    }

    private final void walk(TreeElement $this$walk, Function1<? super MockFolder, Unit> folderRun, Function1<? super Mock, Unit> mockRun) {
        TreeObject obj = $this$walk.getObj();
        if (obj instanceof MockFolder) {
            folderRun.invoke((Object)obj);
            Iterable $this$forEach$iv = $this$walk.getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TreeElement it = (TreeElement)element$iv;
                boolean bl = false;
                this.walk(it, folderRun, mockRun);
            }
        } else if (obj instanceof Mock) {
            mockRun.invoke((Object)obj);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    static /* synthetic */ void walk$default(MockServiceImpl mockServiceImpl, TreeElement treeElement, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = MockServiceImpl::walk$lambda$0;
        }
        if ((n & 2) != 0) {
            function12 = MockServiceImpl::walk$lambda$1;
        }
        mockServiceImpl.walk(treeElement, (Function1<? super MockFolder, Unit>)function1, (Function1<? super Mock, Unit>)function12);
    }

    private final List<MockFolder> collectFolders(TreeElement $this$collectFolders, Function1<? super MockFolder, Boolean> predicate) {
        List folders = new ArrayList();
        if ($this$collectFolders.getObj() instanceof MockFolder) {
            TreeObject treeObject = $this$collectFolders.getObj();
            Intrinsics.checkNotNull((Object)treeObject, (String)"null cannot be cast to non-null type com.btc.flowix.jbplugin.data.MockFolder");
            MockFolder mf = (MockFolder)treeObject;
            if (((Boolean)predicate.invoke((Object)mf)).booleanValue()) {
                folders.add(mf);
            }
            Iterable $this$forEach$iv = $this$collectFolders.getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TreeElement it = (TreeElement)element$iv;
                boolean bl = false;
                folders.addAll((Collection)this.collectFolders(it, predicate));
            }
        }
        return folders;
    }

    private final List<Mock> collectMocks(TreeElement $this$collectMocks, Function1<? super Mock, Boolean> predicate) {
        List mocks = new ArrayList();
        TreeObject obj = $this$collectMocks.getObj();
        if (obj instanceof Mock) {
            if (((Boolean)predicate.invoke((Object)obj)).booleanValue()) {
                mocks.add(obj);
            }
        } else if (obj instanceof MockFolder) {
            Iterable $this$forEach$iv = $this$collectMocks.getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TreeElement it = (TreeElement)element$iv;
                boolean bl = false;
                mocks.addAll((Collection)this.collectMocks(it, predicate));
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return mocks;
    }

    @Override
    @NotNull
    public String getMockPath(@NotNull UUID mockId) {
        String string;
        block5: {
            block4: {
                Object v0;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)mockId, (String)"mockId");
                    Iterable iterable = this.mocks;
                    for (Object t : iterable) {
                        Mock it = (Mock)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)mockId)) continue;
                        v0 = t;
                        break block3;
                    }
                    v0 = null;
                }
                Mock mock = v0;
                if (mock == null) break block4;
                Mock it = mock;
                boolean bl = false;
                string = it.getMockPath() + "/" + it.getCsvFile();
                if (string != null) break block5;
            }
            throw new IllegalStateException(("Mock " + mockId + "not found").toString());
        }
        return string;
    }

    private static final Unit updateLoadedMocks$lambda$0(Map $loaded, Mock mock) {
        Intrinsics.checkNotNullParameter((Object)mock, (String)"mock");
        Boolean enabled = (Boolean)$loaded.get(mock.getId());
        mock.setState(enabled == null ? MockState.CORRUPTED : (enabled != false ? MockState.ON_FLY : MockState.DISABLED));
        return Unit.INSTANCE;
    }

    private static final boolean loadMocksIfRequired$lambda$0(MockFolder mf) {
        Intrinsics.checkNotNullParameter((Object)mf, (String)"mf");
        return !mf.getEnabled();
    }

    private static final boolean loadMocksIfRequired$lambda$1(Mock mock) {
        Intrinsics.checkNotNullParameter((Object)mock, (String)"mock");
        return mock.getState() == MockState.DISABLED;
    }

    private static final Unit loadMocksIfRequired$lambda$2(List $disabledFolders, MockFolder folder) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
            Iterable $this$any$iv = $disabledFolders;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MockFolder df = (MockFolder)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)df.getPath(), (Object)folder.getPath())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            folder.setEnabled(false);
        }
        return Unit.INSTANCE;
    }

    private static final Unit loadMocksIfRequired$lambda$3(List $disabledMocks, MockServiceImpl this$0, Mock mock) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)mock, (String)"mock");
            Iterable $this$any$iv = $disabledMocks;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Mock dm = (Mock)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)dm.getId(), (Object)mock.getId())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            mock.setState(MockState.DISABLED);
            this$0.log.debug("loadMock: mock: " + mock.getId() + ", " + mock + ", state: " + mock.getState());
        }
        return Unit.INSTANCE;
    }

    private static final boolean saveMocks$lambda$1$0$1(Map.Entry $pathAndMocks, Mock it) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Iterable $this$any$iv = (Iterable)$pathAndMocks.getValue();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Mock m = (Mock)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)m.getId(), (Object)it.getId())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean saveMocks$lambda$1$0$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit walk$lambda$0(MockFolder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit walk$lambda$1(Mock it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }
}

