/*
 * Decompiled with CFR 0.152.
 */
package com.btc.flowix.jbplugin.services;

import com.btc.flowix.jbplugin.IJLogger;
import com.btc.flowix.jbplugin.LoggerFacade;
import com.btc.flowix.jbplugin.SoutLogger;
import com.btc.flowix.jbplugin.TopLevelKt;
import com.btc.flowix.jbplugin.actions.ToolbarState;
import com.btc.flowix.jbplugin.configuration.Keys;
import com.btc.flowix.jbplugin.data.DataGenRequest;
import com.btc.flowix.jbplugin.data.Mock;
import com.btc.flowix.jbplugin.data.MockFolder;
import com.btc.flowix.jbplugin.data.MockState;
import com.btc.flowix.jbplugin.data.TreeObject;
import com.btc.flowix.jbplugin.data.serialization.JacksonSerializer;
import com.btc.flowix.jbplugin.data.serialization.NioFileAccessor;
import com.btc.flowix.jbplugin.data.serialization.VirtualFileAccessor;
import com.btc.flowix.jbplugin.listeners.Topics;
import com.btc.flowix.jbplugin.services.ConfigService;
import com.btc.flowix.jbplugin.services.ManagerService;
import com.btc.flowix.jbplugin.services.MockService;
import com.btc.flowix.jbplugin.services.MockServiceImpl;
import com.btc.flowix.jbplugin.ui.mockstree.TreeElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0018J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\u0006\u0010\u001b\u001a\u00020\u0018J\u0016\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020 J\u0016\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020 J\u000e\u0010%\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020 J\u0016\u0010&\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020 J\u0014\u0010'\u001a\u00020\u00182\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)J\u000e\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020*J\u000e\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020\u001eJ\u000e\u0010/\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u001eJ\u000e\u00100\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u001eJ\u0010\u00101\u001a\u00020\u00182\u0006\u00102\u001a\u00020\u001eH\u0002J\u0010\u00103\u001a\u00020\u00132\u0006\u00102\u001a\u00020\u001eH\u0002J\u0010\u00104\u001a\u00020\u00182\u0006\u00102\u001a\u00020\u001eH\u0002J\u000e\u00105\u001a\u00020\u00182\u0006\u00106\u001a\u00020 J\u0012\u00107\u001a\b\u0012\u0004\u0012\u00020*0)*\u00020 H\u0002J\u0010\u00108\u001a\u00020\u00182\u0006\u00109\u001a\u00020:H\u0002J\b\u0010;\u001a\u00020\u0018H\u0002J\b\u0010<\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006="}, d2={"Lcom/btc/flowix/jbplugin/services/FlowixService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "configService", "Lcom/btc/flowix/jbplugin/services/ConfigService;", "managerService", "Lcom/btc/flowix/jbplugin/services/ManagerService;", "fileAccessor", "Lcom/btc/flowix/jbplugin/data/serialization/VirtualFileAccessor;", "mockService", "Lcom/btc/flowix/jbplugin/services/MockServiceImpl;", "process", "Ljava/lang/Process;", "logger", "Lcom/btc/flowix/jbplugin/LoggerFacade;", "value", "", "ready", "getReady", "()Z", "initialize", "", "start", "startServer", "stop", "updateLoadedMocks", "message", "", "node", "Lcom/btc/flowix/jbplugin/ui/mockstree/TreeElement;", "loadMocks", "root", "loadMocksIfRequired", "changedFile", "loadTraces", "loadTracesIfRequired", "saveMocks", "mocks", "", "Lcom/btc/flowix/jbplugin/data/Mock;", "deleteMock", "mock", "newMock", "nodePath", "newFolder", "removeFolder", "reloadVirtualFile", "path", "closeFile", "openFile", "switchState", "el", "collectMocks", "generateData", "request", "Lcom/btc/flowix/jbplugin/data/DataGenRequest;", "killServer", "dispose", "flowixsql"})
@SourceDebugExtension(value={"SMAP\nFlowixService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlowixService.kt\ncom/btc/flowix/jbplugin/services/FlowixService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 TopLevel.kt\ncom/btc/flowix/jbplugin/TopLevelKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,279:1\n30#2,2:280\n30#2,2:282\n79#3,5:284\n1869#4,2:289\n1374#4:292\n1460#4,5:293\n1#5:291\n*S KotlinDebug\n*F\n+ 1 FlowixService.kt\ncom/btc/flowix/jbplugin/services/FlowixService\n*L\n39#1:280,2\n40#1:282,2\n44#1:284,5\n173#1:289,2\n259#1:292\n259#1:293,5\n*E\n"})
public final class FlowixService
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final ConfigService configService;
    @NotNull
    private final ManagerService managerService;
    @NotNull
    private final VirtualFileAccessor fileAccessor;
    @NotNull
    private final MockServiceImpl mockService;
    @Nullable
    private Process process;
    @NotNull
    private final LoggerFacade logger;
    private boolean ready;

    public FlowixService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class serviceClass$iv = ConfigService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.configService = (ConfigService)object;
        $this$service$iv = (ComponentManager)this.project;
        $i$f$service = false;
        serviceClass$iv = ManagerService.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.managerService = (ManagerService)object2;
        this.fileAccessor = new VirtualFileAccessor();
        this.mockService = new MockServiceImpl(this.fileAccessor);
        FlowixService $this$getLogger$iv = this;
        boolean $i$f$getLogger = false;
        this.logger = ApplicationManager.getApplication() != null ? (LoggerFacade)new IJLogger(FlowixService.class) : (LoggerFacade)new SoutLogger(FlowixService.class);
        MessageBusConnection $this$_init__u24lambda_u240 = this.project.getMessageBus().connect();
        boolean bl = false;
        $this$_init__u24lambda_u240.subscribe(Topics.INSTANCE.getAPP_CONNECTED(), () -> FlowixService.lambda$0$0(this));
        $this$_init__u24lambda_u240.subscribe(Topics.INSTANCE.getAPP_DISCONNECTED(), () -> FlowixService.lambda$0$1(this));
        $this$_init__u24lambda_u240.subscribe(Topics.INSTANCE.getSERVER_QUIT_EVENT(), arg_0 -> FlowixService.lambda$0$2(this, arg_0));
        $this$_init__u24lambda_u240.subscribe(Topics.INSTANCE.getSERVER_NOTIFICATION_EVENT(), FlowixService::lambda$0$3);
        $this$_init__u24lambda_u240.subscribe(Topics.INSTANCE.getGENERATION_REQUEST_EVENT(), arg_0 -> FlowixService.lambda$0$4(this, arg_0));
    }

    public final boolean getReady() {
        return this.ready;
    }

    public final void initialize() {
        boolean success = this.configService.loadConfiguration();
        if (success) {
            this.configService.installServer();
        } else {
            TopLevelKt.notifyError("Could not load configuration");
        }
    }

    public final void start() {
        boolean ready = this.configService.loadConfiguration();
        if (ready) {
            this.startServer();
        }
    }

    private final void startServer() {
        String jarPath = this.configService.getServerArtifactName();
        String[] stringArray = new String[]{"bin", "java"};
        String javaBin = ((Object)Paths.get(System.getProperty("java.home"), stringArray)).toString();
        SpreadBuilder spreadBuilder = new SpreadBuilder(5);
        spreadBuilder.add((Object)javaBin);
        spreadBuilder.addSpread((Object)this.configService.getJVMArguments());
        spreadBuilder.add((Object)"-jar");
        spreadBuilder.add((Object)jarPath);
        spreadBuilder.addSpread((Object)this.configService.getArguments());
        ProcessBuilder pb = new ProcessBuilder((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
        pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        File workDir = new File(this.configService.getConfigPath());
        pb.directory(workDir);
        if (!FilesKt.resolve((File)workDir, (String)jarPath).exists()) {
            TopLevelKt.notifyError("Server file " + jarPath + " not found. Please reopen the IDE");
            return;
        }
        this.process = pb.start();
        Thread printingHook = new Thread(() -> FlowixService.startServer$lambda$0(this));
        Runtime.getRuntime().addShutdownHook(printingHook);
    }

    public final void stop() {
        block0: {
            TopLevelKt.submitEvent(this.project, Topics.INSTANCE.getMOCK_TREE_CLEARING_EVENT());
            this.project.putUserData(Keys.INSTANCE.getTOOLBAR_STATE(), (Object)new ToolbarState(true, false));
            TopLevelKt.refreshToolbar(this.project);
            Process process = this.process;
            if (process == null) break block0;
            process.destroy();
        }
    }

    public final void updateLoadedMocks(@NotNull String message, @NotNull TreeElement node) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.mockService.updateLoadedMocks(message, node);
        String string = this.configService.getMockDirectory().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        this.reloadVirtualFile(string);
    }

    public final void loadMocks(@NotNull TreeElement root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.mockService.loadMocks(root, this.configService.getMockDirectory());
    }

    public final void loadMocksIfRequired(@NotNull String changedFile, @NotNull TreeElement root) {
        Intrinsics.checkNotNullParameter((Object)changedFile, (String)"changedFile");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.mockService.loadMocksIfRequired(changedFile, root, this.configService.getMockDirectory());
    }

    public final void loadTraces(@NotNull TreeElement root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.mockService.loadTraces(root, this.configService.getLogDirectory());
    }

    public final void loadTracesIfRequired(@NotNull String changedFile, @NotNull TreeElement root) {
        Intrinsics.checkNotNullParameter((Object)changedFile, (String)"changedFile");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.mockService.loadTracesIfRequired(changedFile, root, this.configService.getLogDirectory());
        String string = this.configService.getLogDirectory().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        this.reloadVirtualFile(string);
    }

    public final void saveMocks(@NotNull List<Mock> mocks) {
        Intrinsics.checkNotNullParameter(mocks, (String)"mocks");
        this.mockService.saveMocks(mocks);
        Iterable $this$forEach$iv = mocks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path csvPath;
            Mock mock = (Mock)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)Paths.get(mock.getMockPath() + "/" + mock.getCsvFile(), new String[0]), (String)"get(...)");
            if (!Files.exists(csvPath, new LinkOption[0]) && mock.getCsvFile() != null) {
                Files.createFile(csvPath, new FileAttribute[0]);
                TopLevelKt.notifyInfo("Created " + csvPath.getFileName());
            }
            this.reloadVirtualFile(((Object)mock.getFullMockPath()).toString());
            if (Intrinsics.areEqual((Object)mock.getFullMockPath(), (Object)mock.getStartFullMockPath())) continue;
            this.reloadVirtualFile(((Object)mock.getStartFullMockPath()).toString());
        }
        if (mocks.size() == 1) {
            TopLevelKt.notifyInfo("Saved " + ((Mock)CollectionsKt.first(mocks)).getMockFileName());
        }
    }

    public final void deleteMock(@NotNull Mock mock) {
        Intrinsics.checkNotNullParameter((Object)mock, (String)"mock");
        MockService.DeletingResult result = this.mockService.deleteMock(mock);
        switch (WhenMappings.$EnumSwitchMapping$0[result.ordinal()]) {
            case 1: {
                TopLevelKt.notifyInfo("Saved " + mock.getMockFileName());
                this.reloadVirtualFile(((Object)mock.getStartFullMockPath()).toString());
                break;
            }
            case 2: {
                TopLevelKt.notifyInfo("Deleted " + mock.getMockFileName());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.logger.info("removed mock: " + mock.getId());
    }

    @NotNull
    public final Mock newMock(@NotNull String nodePath) {
        Mock mock;
        Intrinsics.checkNotNullParameter((Object)nodePath, (String)"nodePath");
        String path = this.configService.getMockDirectory().getParent() + "/" + nodePath;
        Mock it = mock = this.mockService.newMock(path);
        boolean bl = false;
        TopLevelKt.notifyInfo("Created mock: " + it.getId());
        return mock;
    }

    @NotNull
    public final String newFolder(@NotNull String nodePath) {
        Intrinsics.checkNotNullParameter((Object)nodePath, (String)"nodePath");
        String string = this.configService.getMockDirectory().getParent();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParent(...)");
        return this.mockService.newMockDir(string, nodePath);
    }

    public final void removeFolder(@NotNull String nodePath) {
        Intrinsics.checkNotNullParameter((Object)nodePath, (String)"nodePath");
        String fullPath = this.configService.getMockDirectory().getParent() + "/" + nodePath;
        this.mockService.removeMockDir(fullPath);
        String string = this.configService.getMockDirectory().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this.reloadVirtualFile(string);
    }

    private final void reloadVirtualFile(String path) {
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl("file://" + path);
        this.logger.debug(String.valueOf(virtualFile));
        if (virtualFile != null) {
            Application app = ApplicationManager.getApplication();
            app.invokeLater(() -> FlowixService.reloadVirtualFile$lambda$0(app, virtualFile));
        }
    }

    private final boolean closeFile(String path) {
        boolean bl;
        VirtualFile virtualFile;
        FileEditorManager manager = FileEditorManager.getInstance((Project)this.project);
        VirtualFile virtualFile2 = virtualFile = VirtualFileManager.getInstance().findFileByUrl("file://" + path);
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl2 = false;
            manager.closeFile(it);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void openFile(String path) {
        block0: {
            VirtualFile virtualFile;
            FileEditorManager manager = FileEditorManager.getInstance((Project)this.project);
            VirtualFile virtualFile2 = virtualFile = VirtualFileManager.getInstance().findFileByUrl("file://" + path);
            if (virtualFile2 == null) break block0;
            VirtualFile it = virtualFile2;
            boolean bl = false;
            manager.openFile(it);
        }
    }

    public final void switchState(@NotNull TreeElement el) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)el, (String)"el");
        TreeObject ob = el.getObj();
        if (ob instanceof MockFolder) {
            bl = ((MockFolder)ob).getEnabled();
        } else if (ob instanceof Mock) {
            bl = ((Mock)ob).getState() == MockState.ON_FLY;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        boolean enabled = bl;
        this.mockService.switchState(el, !enabled);
        List<Mock> mocks = this.collectMocks(el);
        this.mockService.saveMocks(mocks);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Mock> collectMocks(TreeElement $this$collectMocks) {
        List list;
        TreeObject ob = $this$collectMocks.getObj();
        if (ob instanceof Mock) {
            list = CollectionsKt.listOf((Object)ob);
        } else if (ob instanceof MockFolder) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = $this$collectMocks.getChildren();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                TreeElement el = (TreeElement)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = this.collectMocks(el);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    private final void generateData(DataGenRequest request) {
        Path metadataPath = this.configService.getSystemDirectory().toPath().resolve(TopLevelKt.buildGenMetadataFileName(request.getMockId()));
        JacksonSerializer jacksonSerializer = JacksonSerializer.Companion.jsonSerializer(new NioFileAccessor());
        Intrinsics.checkNotNull((Object)metadataPath);
        jacksonSerializer.serialize(request, metadataPath);
        this.managerService.generateData(((Object)metadataPath).toString());
    }

    private final void killServer() {
        block0: {
            this.logger.info("Destroying the server process...");
            Process process = this.process;
            if (process == null) break block0;
            process.destroy();
        }
    }

    public void dispose() {
        this.killServer();
    }

    private static final void lambda$0$0(FlowixService this$0) {
        this$0.ready = true;
    }

    private static final void lambda$0$1(FlowixService this$0) {
        this$0.ready = false;
    }

    private static final void lambda$0$2(FlowixService this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.ready = false;
        this$0.stop();
    }

    private static final void lambda$0$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean error = StringsKt.first((CharSequence)it) == 'E';
        String string = it.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String body = string;
        if (error) {
            TopLevelKt.notifyError(body);
        } else {
            TopLevelKt.notifyInfo(body);
        }
    }

    private static final void lambda$0$4(FlowixService this$0, DataGenRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.generateData(it);
    }

    private static final void startServer$lambda$0(FlowixService this$0) {
        this$0.killServer();
    }

    private static final void reloadVirtualFile$lambda$0(Application $app, VirtualFile $virtualFile) {
        $app.runWriteAction(() -> FlowixService.reloadVirtualFile$lambda$0$0($virtualFile));
    }

    private static final void reloadVirtualFile$lambda$0$0(VirtualFile $virtualFile) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager docManager = fileDocumentManager;
        Document document = docManager.getCachedDocument($virtualFile);
        if (document == null) {
            document = docManager.getDocument($virtualFile);
        }
        Document document2 = document;
        $virtualFile.refresh(false, true);
        if (document2 != null) {
            docManager.reloadFromDisk(document2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MockService.DeletingResult.values().length];
            try {
                nArray[MockService.DeletingResult.FILE_SAVED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MockService.DeletingResult.FILE_DELETED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

