/*
 * Decompiled with CFR 0.152.
 */
package com.btc.flowix.jbplugin.data.serialization;

import com.btc.flowix.jbplugin.data.serialization.FileAccessor;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/btc/flowix/jbplugin/data/serialization/NioFileAccessor;", "Lcom/btc/flowix/jbplugin/data/serialization/FileAccessor;", "<init>", "()V", "getContent", "", "path", "Ljava/nio/file/Path;", "createFile", "fileName", "writeContentToFile", "", "content", "removeDirsWithContent", "flowixsql"})
public final class NioFileAccessor
implements FileAccessor {
    @Override
    @NotNull
    public String getContent(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = Files.readString(path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        return string;
    }

    @Override
    @NotNull
    public Path createFile(@NotNull String path, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Path path2 = Files.createFile(Paths.get(path, new String[0]).resolve(fileName), new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createFile(...)");
        return path2;
    }

    @Override
    public void writeContentToFile(@NotNull Path path, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Files.writeString(path, (CharSequence)content, new OpenOption[0]);
    }

    @Override
    public void removeDirsWithContent(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path root = Paths.get(path, new String[0]);
        Files.walk(root, new FileVisitOption[0]).sorted((arg_0, arg_1) -> NioFileAccessor.removeDirsWithContent$lambda$1(NioFileAccessor::removeDirsWithContent$lambda$0, arg_0, arg_1)).forEach(arg_0 -> NioFileAccessor.removeDirsWithContent$lambda$3(NioFileAccessor::removeDirsWithContent$lambda$2, arg_0));
    }

    private static final int removeDirsWithContent$lambda$0(Path p1, Path p2) {
        return -p1.compareTo(p2);
    }

    private static final int removeDirsWithContent$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final Unit removeDirsWithContent$lambda$2(Path it) {
        Files.delete(it);
        return Unit.INSTANCE;
    }

    private static final void removeDirsWithContent$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

