/*
 * Decompiled with CFR 0.152.
 */
package com.btc.flowix.jbplugin.data.serialization;

import com.btc.flowix.jbplugin.data.serialization.Deserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\rB\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/btc/flowix/jbplugin/data/serialization/JacksonDeserializer;", "T", "Lcom/btc/flowix/jbplugin/data/serialization/Deserializer;", "cl", "Ljava/lang/Class;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Ljava/lang/Class;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "parse", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)Ljava/lang/Object;", "Companion", "flowixsql"})
public final class JacksonDeserializer<T>
implements Deserializer<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Class<T> cl;
    @NotNull
    private final ObjectMapper mapper;

    public JacksonDeserializer(@NotNull Class<T> cl, @NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter(cl, (String)"cl");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.cl = cl;
        this.mapper = mapper;
    }

    @Override
    @Nullable
    public T parse(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return (T)this.mapper.readValue(path.toFile(), this.cl);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bJ \u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\b\u00a8\u0006\n"}, d2={"Lcom/btc/flowix/jbplugin/data/serialization/JacksonDeserializer$Companion;", "", "<init>", "()V", "jsonDeserializer", "Lcom/btc/flowix/jbplugin/data/serialization/JacksonDeserializer;", "T", "cl", "Ljava/lang/Class;", "yamlDeserializer", "flowixsql"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> JacksonDeserializer<T> jsonDeserializer(@NotNull Class<T> cl) {
            Intrinsics.checkNotNullParameter(cl, (String)"cl");
            ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new KotlinModule.Builder().build());
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"registerModule(...)");
            return new JacksonDeserializer<T>(cl, objectMapper);
        }

        @NotNull
        public final <T> JacksonDeserializer<T> yamlDeserializer(@NotNull Class<T> cl) {
            Intrinsics.checkNotNullParameter(cl, (String)"cl");
            ObjectMapper objectMapper = new YAMLMapper().registerModule((Module)new KotlinModule.Builder().build());
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"registerModule(...)");
            return new JacksonDeserializer<T>(cl, objectMapper);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

