/*
 * Decompiled with CFR 0.152.
 */
package com.btc.flowix.jbplugin.data.serialization;

import com.btc.flowix.jbplugin.TopLevelKt;
import com.btc.flowix.jbplugin.configuration.DatabaseConfig;
import com.btc.flowix.jbplugin.configuration.FlowixConfig;
import com.btc.flowix.jbplugin.configuration.FlowixSection;
import com.btc.flowix.jbplugin.configuration.TracingConfig;
import com.btc.flowix.jbplugin.data.serialization.Deserializer;
import com.btc.flowix.jbplugin.data.serialization.MapExtensionsKt;
import com.btc.flowix.jbplugin.data.serialization.MapYamlParsersKt;
import com.btc.flowix.jbplugin.data.serialization.RawReader;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/btc/flowix/jbplugin/data/serialization/FlowixConfigDeserializer;", "Lcom/btc/flowix/jbplugin/data/serialization/Deserializer;", "Lcom/btc/flowix/jbplugin/configuration/FlowixConfig;", "reader", "Lcom/btc/flowix/jbplugin/data/serialization/RawReader;", "<init>", "(Lcom/btc/flowix/jbplugin/data/serialization/RawReader;)V", "parse", "path", "Ljava/nio/file/Path;", "flowixsql"})
public final class FlowixConfigDeserializer
implements Deserializer<FlowixConfig> {
    @NotNull
    private final RawReader reader;

    public FlowixConfigDeserializer(@NotNull RawReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.reader = reader;
    }

    @Override
    @Nullable
    public FlowixConfig parse(@NotNull Path path) {
        Object object;
        Object $this$parse_u24lambda_u242;
        Object object2;
        Object $this$parse_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Map<String, Object> map = MapYamlParsersKt.safeReadMap(this.reader, path);
        if (map == null) {
            return null;
        }
        Map<String, Object> configMap = map;
        Map<String, Object> database = MapYamlParsersKt.safeReadSubMap(configMap, "database");
        Map<String, Object> flowix = MapYamlParsersKt.safeReadSubMap(configMap, "flowix");
        Object object3 = flowix.get("tracing");
        Map tracing = object3 instanceof Map ? (Map)object3 : null;
        Object object4 = this;
        try {
            $this$parse_u24lambda_u240 = object4;
            boolean bl = false;
            $this$parse_u24lambda_u240 = Result.constructor-impl((Object)new DatabaseConfig(MapExtensionsKt.getStringValueStrict(database, "host"), MapExtensionsKt.getIntValueStrict(database, "port")));
        }
        catch (Throwable bl) {
            $this$parse_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object4 = $this$parse_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object4);
        if (throwable == null) {
            object2 = object4;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            TopLevelKt.notifyError("Check database section in flowix.yaml: " + it.getMessage());
            object2 = new DatabaseConfig("", -1);
        }
        DatabaseConfig databaseSection = (DatabaseConfig)object2;
        Object object5 = this;
        try {
            $this$parse_u24lambda_u242 = object5;
            boolean bl = false;
            int n = MapExtensionsKt.getIntValue(flowix, "localPort", 10001);
            int n2 = MapExtensionsKt.getIntValueStrict(flowix, "managePort");
            String string = MapExtensionsKt.getStringValueStrict(flowix, "logLevel");
            Integer n3 = MapExtensionsKt.getIntValueOrNull(flowix, "maxHeapSize");
            boolean bl2 = MapExtensionsKt.getBooleanValue(flowix, "forceExit", false);
            boolean bl3 = MapExtensionsKt.getBooleanValue(flowix, "debug", false);
            Map map2 = tracing;
            List list = map2 != null ? MapYamlParsersKt.safeReadSubList(map2, "filters") : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            TracingConfig tracingConfig = new TracingConfig(list);
            $this$parse_u24lambda_u242 = Result.constructor-impl((Object)new FlowixSection(n, n2, bl2, n3, string, tracingConfig, bl3));
        }
        catch (Throwable bl) {
            $this$parse_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object5 = $this$parse_u24lambda_u242;
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object5);
        if (throwable2 == null) {
            object = object5;
        } else {
            Throwable it = throwable2;
            boolean bl = false;
            TopLevelKt.notifyError("Check flowix section in flowix.yaml: " + it.getMessage());
            object = new FlowixSection(10001, 7777, false, null, "INFO", new TracingConfig(CollectionsKt.listOf((Object)"")), false);
        }
        FlowixSection flowixSection = (FlowixSection)object;
        return new FlowixConfig(databaseSection, flowixSection);
    }
}

