/*
 * Decompiled with CFR 0.152.
 */
package com.btc.flowix.jbplugin.services;

import com.btc.flowix.jbplugin.IJLogger;
import com.btc.flowix.jbplugin.LoggerFacade;
import com.btc.flowix.jbplugin.SoutLogger;
import com.btc.flowix.jbplugin.TopLevelKt;
import com.btc.flowix.jbplugin.actions.ToolbarState;
import com.btc.flowix.jbplugin.configuration.FlowixConfig;
import com.btc.flowix.jbplugin.configuration.FlowixSection;
import com.btc.flowix.jbplugin.configuration.Keys;
import com.btc.flowix.jbplugin.configuration.NetworkServerInstaller;
import com.btc.flowix.jbplugin.configuration.ResourceServerInstaller;
import com.btc.flowix.jbplugin.configuration.ServerInstaller;
import com.btc.flowix.jbplugin.data.serialization.FlowixConfigParser;
import com.btc.flowix.jbplugin.data.serialization.SnakeYamlReader;
import com.btc.flowix.jbplugin.data.serialization.VirtualFileAccessor;
import com.btc.flowix.jbplugin.data.serialization.YamlReader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001f\u001a\u00020\u001cJ\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020\u001cH\u0002J\b\u0010#\u001a\u00020!H\u0002J\b\u0010$\u001a\u00020\u001cH\u0002J\u0011\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070&\u00a2\u0006\u0002\u0010'J\u0011\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00070&\u00a2\u0006\u0002\u0010'R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/btc/flowix/jbplugin/services/ConfigService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "flowixFileName", "", "flowixConfig", "Lcom/btc/flowix/jbplugin/configuration/FlowixConfig;", "configPath", "getConfigPath", "()Ljava/lang/String;", "serverArtifactName", "getServerArtifactName", "managePort", "", "getManagePort", "()I", "logDirectory", "Ljava/io/File;", "getLogDirectory", "()Ljava/io/File;", "mockDirectory", "getMockDirectory", "yamlReader", "Lcom/btc/flowix/jbplugin/data/serialization/YamlReader;", "networkInstaller", "", "logger", "Lcom/btc/flowix/jbplugin/LoggerFacade;", "loadConfiguration", "installServer", "", "createConfigIfNotExists", "excludeFromIndexing", "loadFlowixConfig", "getArguments", "", "()[Ljava/lang/String;", "getJVMArguments", "flowixsql"})
@SourceDebugExtension(value={"SMAP\nConfigService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigService.kt\ncom/btc/flowix/jbplugin/services/ConfigService\n+ 2 TopLevel.kt\ncom/btc/flowix/jbplugin/TopLevelKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,152:1\n73#2,5:153\n37#3:158\n36#3,3:159\n37#3:162\n36#3,3:163\n1310#4,2:166\n*S KotlinDebug\n*F\n+ 1 ConfigService.kt\ncom/btc/flowix/jbplugin/services/ConfigService\n*L\n45#1:153,5\n139#1:158\n139#1:159,3\n149#1:162\n149#1:163,3\n106#1:166,2\n*E\n"})
public final class ConfigService {
    @NotNull
    private final Project project;
    @NotNull
    private final String flowixFileName;
    @Nullable
    private FlowixConfig flowixConfig;
    @NotNull
    private final String configPath;
    @NotNull
    private final YamlReader yamlReader;
    private final boolean networkInstaller;
    @NotNull
    private final LoggerFacade logger;

    public ConfigService(@NotNull Project project) {
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.flowixFileName = "flowix.yaml";
        this.configPath = this.project.getBasePath() + "/.flowix";
        this.yamlReader = new SnakeYamlReader(new VirtualFileAccessor());
        this.networkInstaller = System.getenv("FX_NETWORK_INSTALLER") != null;
        ConfigService $this$getLogger$iv = this;
        boolean $i$f$getLogger = false;
        this.logger = ApplicationManager.getApplication() != null ? (LoggerFacade)new IJLogger(ConfigService.class) : (LoggerFacade)new SoutLogger(ConfigService.class);
        this.project.putUserData(Keys.INSTANCE.getFLOWIX_PATH(), (Object)this.configPath);
        this.project.putUserData(Keys.INSTANCE.getMOCK_PATH(), (Object)this.getMockDirectory());
        this.project.putUserData(Keys.INSTANCE.getTOOLBAR_STATE(), (Object)new ToolbarState(true, false));
        MatchResult matchResult = Regex.find$default((Regex)new Regex("[a-z\\-]+(\\d\\.\\d\\.\\d(-SNAPSHOT)?)\\.jar"), (CharSequence)this.getServerArtifactName(), (int)0, (int)2, null);
        this.logger.info("Flowix server version: " + (matchResult != null && (list = matchResult.getGroupValues()) != null ? (String)list.get(1) : null));
    }

    @NotNull
    public final String getConfigPath() {
        return this.configPath;
    }

    @NotNull
    public final String getServerArtifactName() {
        URL uRL = this.getClass().getClassLoader().getResource("backName");
        if (uRL == null) {
            throw new IllegalStateException("Unable to get the server artifact name".toString());
        }
        URL uRL2 = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
        return new String(byArray, charset);
    }

    public final int getManagePort() {
        Object object = this.flowixConfig;
        if (object == null || (object = ((FlowixConfig)object).getFlowix()) == null) {
            throw new IllegalStateException("flowixConfig is null".toString());
        }
        return ((FlowixSection)object).getManagePort();
    }

    @NotNull
    public final File getLogDirectory() {
        return new File(this.configPath + "/traces");
    }

    @NotNull
    public final File getMockDirectory() {
        return new File(this.configPath + "/mocks");
    }

    public final boolean loadConfiguration() {
        boolean configurationReady = this.createConfigIfNotExists() && this.loadFlowixConfig();
        Object object = this.flowixConfig;
        return (object != null && (object = ((FlowixConfig)object).getFlowix()) != null ? ((FlowixSection)object).getDebug() : false) ? false : configurationReady;
    }

    public final void installServer() {
        ServerInstaller installer = this.networkInstaller ? (ServerInstaller)new NetworkServerInstaller(this.project) : (ServerInstaller)new ResourceServerInstaller();
        installer.install(this.configPath, this.getServerArtifactName());
    }

    private final boolean createConfigIfNotExists() {
        File flowixConfigFile;
        boolean result = true;
        String string = this.project.getBasePath();
        if (string == null) {
            return false;
        }
        String projectPath = string;
        File flowixDir = new File(projectPath, ".flowix");
        if (!flowixDir.exists()) {
            flowixDir.mkdirs();
            File dataDir = new File(flowixDir, "traces");
            File mocksDir = new File(flowixDir, "mocks");
            dataDir.mkdirs();
            mocksDir.mkdirs();
        }
        if (!(flowixConfigFile = new File(flowixDir, this.flowixFileName)).exists()) {
            result = TopLevelKt.writeTo("\n        database:\n          host: \"localhost\"     # PostgreSQL host\n          port: 5432            # PostgreSQL port\n\n        flowix:\n          localPort: 10001      # Port for the Flowix backend\n          managePort: 7777      # Port for communication between IDE plugin and backend\n          logLevel: INFO        # Log level for the backend process (FINEST, INFO, SEVERE, OFF)\n          #maxHeapSize: 150     # Maximum heap size in MB (maps to JVM -Xmx)\n          tracing:\n            filters: []         # SQL query filters\n\n    ", flowixConfigFile);
            TopLevelKt.notifyInfo(this.project, "Created .flowix");
        }
        return result;
    }

    private final void excludeFromIndexing() {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.configPath);
        if (virtualFile == null) {
            throw new IllegalStateException(".flowix not found".toString());
        }
        VirtualFile flowixDir = virtualFile;
        Module module = (Module)ArraysKt.firstOrNull((Object[])ModuleManager.Companion.getInstance(this.project).getModules());
        if (module == null) {
            return;
        }
        Module module2 = module;
        ApplicationManager.getApplication().runWriteAction(() -> ConfigService.excludeFromIndexing$lambda$0(module2, flowixDir));
    }

    private final boolean loadFlowixConfig() {
        Path path = Paths.get(this.configPath + "/" + this.flowixFileName, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path file = path;
        FlowixConfig flowixConfig = new FlowixConfigParser(this.yamlReader).parse(file);
        if (flowixConfig == null) {
            return false;
        }
        this.flowixConfig = flowixConfig;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String[] getArguments() {
        void $this$toTypedArray$iv;
        Collection collection;
        FlowixConfig flowixConfig;
        FlowixConfig flowixConfig2 = this.flowixConfig;
        if (flowixConfig2 == null) {
            String string = "flowixConfig is not initialized";
            throw new IllegalStateException(string.toString());
        }
        FlowixConfig $this$getArguments_u24lambda_u240 = flowixConfig = flowixConfig2;
        boolean bl = false;
        List $this$getArguments_u24lambda_u240_u240 = collection = CollectionsKt.createListBuilder();
        boolean bl2 = false;
        $this$getArguments_u24lambda_u240_u240.add("-lp=" + $this$getArguments_u24lambda_u240.getFlowix().getLocalPort());
        $this$getArguments_u24lambda_u240_u240.add("-tp=" + $this$getArguments_u24lambda_u240.getDatabase().getPort());
        $this$getArguments_u24lambda_u240_u240.add("-mp=" + $this$getArguments_u24lambda_u240.getFlowix().getManagePort());
        $this$getArguments_u24lambda_u240_u240.add("-th=" + $this$getArguments_u24lambda_u240.getDatabase().getHost());
        $this$getArguments_u24lambda_u240_u240.add("--mock-path=" + this.getMockDirectory().getPath());
        $this$getArguments_u24lambda_u240_u240.add("--trace-path=" + this.getLogDirectory().getPath());
        List<String> filters = flowixConfig.getFlowix().getTracing().getFilters();
        if (!((Collection)filters).isEmpty()) {
            $this$getArguments_u24lambda_u240_u240.add("-filters=" + CollectionsKt.joinToString$default((Iterable)filters, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        $this$getArguments_u24lambda_u240_u240.add("-ll=" + $this$getArguments_u24lambda_u240.getFlowix().getLogLevel());
        if (!$this$getArguments_u24lambda_u240.getFlowix().getForceExit()) {
            $this$getArguments_u24lambda_u240_u240.add("--disable-force-exit=true");
        }
        collection = CollectionsKt.build((List)collection);
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @NotNull
    public final String[] getJVMArguments() {
        List list;
        FlowixConfig flowixConfig = this.flowixConfig;
        if (flowixConfig == null) {
            throw new IllegalStateException("flowixConfig is not initialized".toString());
        }
        FlowixConfig flowixConfig2 = flowixConfig;
        List $this$getJVMArguments_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Integer n = flowixConfig2.getFlowix().getMaxHeapSize();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            $this$getJVMArguments_u24lambda_u240.add("-Xmx" + it + "m");
        }
        Collection $this$toTypedArray$iv = CollectionsKt.build((List)list);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    /*
     * Unable to fully structure code
     */
    private static final void excludeFromIndexing$lambda$0(Module $module, VirtualFile $flowixDir) {
        block5: {
            v0 = ModuleRootManager.getInstance((Module)$module).getModifiableModel();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getModifiableModel(...)");
            modifiableModel = v0;
            v1 = modifiableModel.getContentEntries();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getContentEntries(...)");
            $this$firstOrNull$iv = v1;
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                contentEntry = (ContentEntry)element$iv;
                $i$a$-firstOrNull-ConfigService$excludeFromIndexing$1$contentEntry$1 = false;
                if (contentEntry.getFile() == null) ** GOTO lbl-1000
                v2 = $flowixDir.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getPath(...)");
                v3 = contentEntry.getFile();
                Intrinsics.checkNotNull((Object)v3);
                v4 = v3.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getPath(...)");
                if (StringsKt.startsWith$default((String)v2, (String)v4, (boolean)false, (int)2, null)) {
                    v5 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = false;
                }
                if (!v5) continue;
                v6 = element$iv;
                break block5;
            }
            v6 = null;
        }
        contentEntry = (ContentEntry)v6;
        if (contentEntry != null) {
            contentEntry.addExcludeFolder($flowixDir);
            modifiableModel.commit();
        } else {
            modifiableModel.dispose();
        }
    }
}

