/*
 * Decompiled with CFR 0.152.
 */
package com.btc.flowix.jbplugin.data.serialization;

import com.btc.flowix.jbplugin.configuration.DatabaseConfig;
import com.btc.flowix.jbplugin.configuration.FlowixConfig;
import com.btc.flowix.jbplugin.configuration.FlowixSection;
import com.btc.flowix.jbplugin.configuration.TracingConfig;
import com.btc.flowix.jbplugin.data.serialization.MapExtensionsKt;
import com.btc.flowix.jbplugin.data.serialization.MapYamlParsersKt;
import com.btc.flowix.jbplugin.data.serialization.YamlParser;
import com.btc.flowix.jbplugin.data.serialization.YamlReader;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/btc/flowix/jbplugin/data/serialization/FlowixConfigParser;", "Lcom/btc/flowix/jbplugin/data/serialization/YamlParser;", "Lcom/btc/flowix/jbplugin/configuration/FlowixConfig;", "reader", "Lcom/btc/flowix/jbplugin/data/serialization/YamlReader;", "<init>", "(Lcom/btc/flowix/jbplugin/data/serialization/YamlReader;)V", "parse", "path", "Ljava/nio/file/Path;", "flowixsql"})
public final class FlowixConfigParser
implements YamlParser<FlowixConfig> {
    @NotNull
    private final YamlReader reader;

    public FlowixConfigParser(@NotNull YamlReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.reader = reader;
    }

    @Override
    @Nullable
    public FlowixConfig parse(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Map<String, Object> map = MapYamlParsersKt.safeReadMap(this.reader, path);
        if (map == null) {
            return null;
        }
        Map<String, Object> configMap = map;
        Map<String, Object> database = MapYamlParsersKt.safeReadSubMap(configMap, "database");
        Map<String, Object> flowix = MapYamlParsersKt.safeReadSubMap(configMap, "flowix");
        Map tracing = (Map)flowix.get("tracing");
        DatabaseConfig databaseConfig = new DatabaseConfig(MapExtensionsKt.getStringValueStrict(database, "host"), MapExtensionsKt.getIntValue(database, "port", 5432));
        int n = MapExtensionsKt.getIntValue(flowix, "localPort", 10001);
        int n2 = MapExtensionsKt.getIntValue(flowix, "managePort", 7777);
        String string = MapExtensionsKt.getStringValueStrict(flowix, "logLevel");
        Integer n3 = MapExtensionsKt.getIntValueOrNull(flowix, "maxHeapSize");
        boolean bl = MapExtensionsKt.getBooleanValue(flowix, "forceExit", false);
        boolean bl2 = MapExtensionsKt.getBooleanValue(flowix, "debug", false);
        Map map2 = tracing;
        List list = map2 != null ? MapYamlParsersKt.safeReadSubList(map2, "filters") : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        TracingConfig tracingConfig = new TracingConfig(list);
        return new FlowixConfig(databaseConfig, new FlowixSection(n, n2, bl, n3, string, tracingConfig, bl2));
    }
}

