/*
 * Decompiled with CFR 0.152.
 */
package com.btc.flowix.jbplugin.services;

import com.btc.flowix.jbplugin.IJLogger;
import com.btc.flowix.jbplugin.LoggerFacade;
import com.btc.flowix.jbplugin.SoutLogger;
import com.btc.flowix.jbplugin.TopLevelKt;
import com.btc.flowix.jbplugin.data.Mock;
import com.btc.flowix.jbplugin.data.MockFolder;
import com.btc.flowix.jbplugin.data.MockState;
import com.btc.flowix.jbplugin.data.TreeObject;
import com.btc.flowix.jbplugin.data.serialization.FileAccessor;
import com.btc.flowix.jbplugin.data.serialization.JacksonYamlWriter;
import com.btc.flowix.jbplugin.data.serialization.MockParser;
import com.btc.flowix.jbplugin.data.serialization.NioFileAccessor;
import com.btc.flowix.jbplugin.data.serialization.SnakeYamlReader;
import com.btc.flowix.jbplugin.data.serialization.YamlReader;
import com.btc.flowix.jbplugin.data.serialization.YamlWriter;
import com.btc.flowix.jbplugin.services.MockService;
import com.btc.flowix.jbplugin.services.MockServiceImpl;
import com.btc.flowix.jbplugin.ui.TreeElement;
import com.fasterxml.jackson.core.type.TypeReference;
import com.intellij.openapi.application.ApplicationManager;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0016J \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001a\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u0017H\u0016J \u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0017H\u0016J\u001a\u0010!\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\"\u001a\u0004\u0018\u00010\u0017H\u0016J \u0010#\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0017H\u0016J\u0010\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u001bH\u0016J\u0018\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001bH\u0016J\u0016\u0010(\u001a\u00020\u001d2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\t0\u0019H\u0016J\u0018\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u0015H\u0016J&\u00100\u001a\b\u0012\u0004\u0012\u0002010\u0019*\u00020\u00152\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020-03H\u0002J&\u00104\u001a\b\u0012\u0004\u0012\u00020\t0\u0019*\u00020\u00152\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020-03H\u0002J*\u00105\u001a\u00020\u001d*\u00020\u00172\f\u00106\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u00107\u001a\u00020\u00152\u0006\u00108\u001a\u00020\u001bH\u0002J8\u00109\u001a\u00020\u001d*\u00020\u00152\u0014\b\u0002\u0010:\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020\u001d032\u0014\b\u0002\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001d03H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/btc/flowix/jbplugin/services/MockServiceImpl;", "Lcom/btc/flowix/jbplugin/services/MockService;", "fileAccessor", "Lcom/btc/flowix/jbplugin/data/serialization/FileAccessor;", "(Lcom/btc/flowix/jbplugin/data/serialization/FileAccessor;)V", "log", "Lcom/btc/flowix/jbplugin/LoggerFacade;", "mocks", "", "Lcom/btc/flowix/jbplugin/data/Mock;", "nioFileAccessor", "Lcom/btc/flowix/jbplugin/data/serialization/NioFileAccessor;", "yamlReader", "Lcom/btc/flowix/jbplugin/data/serialization/YamlReader;", "yamlWriter", "Lcom/btc/flowix/jbplugin/data/serialization/YamlWriter;", "deleteMock", "Lcom/btc/flowix/jbplugin/services/MockService$DeletingResult;", "mock", "fillTree", "root", "Lcom/btc/flowix/jbplugin/ui/TreeElement;", "dir", "Ljava/io/File;", "loadMock", "", "path", "", "loadMocks", "", "mockDirectory", "loadMocksIfRequired", "changedFile", "loadTraces", "logDirectory", "loadTracesIfRequired", "newMock", "nodePath", "newMockDir", "parentPath", "saveMocks", "inputMocks", "switchState", "node", "enabled", "", "updateLoadedMocks", "message", "collectFolders", "Lcom/btc/flowix/jbplugin/data/MockFolder;", "predicate", "Lkotlin/Function1;", "collectMocks", "scan", "loaded", "treeNode", "relativePath", "walk", "folderRun", "mockRun", "flowixsql"})
@SourceDebugExtension(value={"SMAP\nMockServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockServiceImpl.kt\ncom/btc/flowix/jbplugin/services/MockServiceImpl\n+ 2 TopLevel.kt\ncom/btc/flowix/jbplugin/TopLevelKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,237:1\n73#2,5:238\n1863#3,2:243\n1485#3:249\n1510#3,3:250\n1513#3,3:260\n774#3:264\n865#3,2:265\n1557#3:267\n1628#3,3:268\n774#3:272\n865#3,2:273\n1863#3,2:275\n1863#3,2:277\n1863#3,2:279\n13409#4,2:245\n13409#4,2:247\n381#5,7:253\n216#6:263\n217#6:271\n*S KotlinDebug\n*F\n+ 1 MockServiceImpl.kt\ncom/btc/flowix/jbplugin/services/MockServiceImpl\n*L\n30#1:238,5\n48#1:243,2\n144#1:249\n144#1:250,3\n144#1:260,3\n150#1:264\n150#1:265,2\n158#1:267\n158#1:268,3\n170#1:272\n170#1:273,2\n208#1:275,2\n219#1:277,2\n231#1:279,2\n109#1:245,2\n125#1:247,2\n144#1:253,7\n145#1:263\n145#1:271\n*E\n"})
public final class MockServiceImpl
implements MockService {
    @NotNull
    private final FileAccessor fileAccessor;
    @NotNull
    private final List<Mock> mocks;
    @NotNull
    private final NioFileAccessor nioFileAccessor;
    @NotNull
    private final YamlReader yamlReader;
    @NotNull
    private final YamlWriter yamlWriter;
    @NotNull
    private final LoggerFacade log;

    public MockServiceImpl(@NotNull FileAccessor fileAccessor) {
        Intrinsics.checkNotNullParameter((Object)fileAccessor, (String)"fileAccessor");
        this.fileAccessor = fileAccessor;
        this.mocks = new ArrayList();
        this.nioFileAccessor = new NioFileAccessor();
        this.yamlReader = new SnakeYamlReader(this.fileAccessor);
        this.yamlWriter = new JacksonYamlWriter(this.nioFileAccessor);
        MockServiceImpl $this$getLogger$iv = this;
        boolean $i$f$getLogger = false;
        this.log = ApplicationManager.getApplication() != null ? (LoggerFacade)new IJLogger(MockServiceImpl.class) : (LoggerFacade)new SoutLogger(MockServiceImpl.class);
    }

    @Override
    public void updateLoadedMocks(@NotNull String message, @NotNull TreeElement node) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        List ids2 = (List)TopLevelKt.deserializeJson(message, (TypeReference)new TypeReference<List<? extends UUID>>(){});
        MockServiceImpl.walk$default(this, node, null, (Function1)new Function1<Mock, Unit>((List<UUID>)ids2){
            final /* synthetic */ List<UUID> $ids;
            {
                this.$ids = $ids;
                super(1);
            }

            public final void invoke(@NotNull Mock mock) {
                Intrinsics.checkNotNullParameter((Object)mock, (String)"mock");
                mock.setState(mock.getState() == MockState.DISABLED ? MockState.DISABLED : (this.$ids.contains(mock.getId()) ? MockState.ON_FLY : MockState.CORRUPTED));
            }
        }, 1, null);
    }

    @Override
    public void switchState(@NotNull TreeElement node, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        TreeObject ob = node.getObj();
        if (ob instanceof MockFolder) {
            ((MockFolder)ob).setEnabled(enabled);
            Iterable $this$forEach$iv = node.getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TreeElement it = (TreeElement)element$iv;
                boolean bl = false;
                this.switchState(it, enabled);
            }
        } else if (ob instanceof Mock) {
            ((Mock)ob).setState(enabled ? MockState.ON_FLY : MockState.DISABLED);
        }
    }

    @Override
    public void loadMocks(@NotNull TreeElement root, @Nullable File mockDirectory) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        File file = mockDirectory;
        Intrinsics.checkNotNull((Object)file);
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        root.setObj(new MockFolder(string, "", true));
        this.mocks.clear();
        this.mocks.addAll((Collection<Mock>)this.fillTree(root, mockDirectory));
    }

    @Override
    public void loadMocksIfRequired(@NotNull String changedFile, @NotNull TreeElement root, @NotNull File mockDirectory) {
        Intrinsics.checkNotNullParameter((Object)changedFile, (String)"changedFile");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)mockDirectory, (String)"mockDirectory");
        Path a = Paths.get(changedFile, new String[0]).normalize();
        Path b = Paths.get(mockDirectory.getPath(), new String[0]).normalize();
        if (a.startsWith(b)) {
            List<MockFolder> disabledFolders2 = this.collectFolders(root, (Function1<? super MockFolder, Boolean>)((Function1)loadMocksIfRequired.disabledFolders.1.INSTANCE));
            List<Mock> disabledMocks2 = this.collectMocks(root, (Function1<? super Mock, Boolean>)((Function1)loadMocksIfRequired.disabledMocks.1.INSTANCE));
            this.mocks.clear();
            this.mocks.addAll((Collection<Mock>)this.fillTree(root, mockDirectory));
            this.walk(root, (Function1<? super MockFolder, Unit>)((Function1)new Function1<MockFolder, Unit>(disabledFolders2){
                final /* synthetic */ List<MockFolder> $disabledFolders;
                {
                    this.$disabledFolders = $disabledFolders;
                    super(1);
                }

                public final void invoke(@NotNull MockFolder folder) {
                    boolean bl;
                    block4: {
                        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
                        Iterable $this$any$iv = this.$disabledFolders;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                MockFolder df = (MockFolder)element$iv;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)df.getPath(), (Object)folder.getPath())) continue;
                                bl = true;
                                break block4;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        folder.setEnabled(false);
                    }
                }
            }), (Function1<? super Mock, Unit>)((Function1)new Function1<Mock, Unit>(disabledMocks2, this){
                final /* synthetic */ List<Mock> $disabledMocks;
                final /* synthetic */ MockServiceImpl this$0;
                {
                    this.$disabledMocks = $disabledMocks;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Mock mock) {
                    boolean bl;
                    block4: {
                        Intrinsics.checkNotNullParameter((Object)mock, (String)"mock");
                        Iterable $this$any$iv = this.$disabledMocks;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                Mock dm = (Mock)element$iv;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)dm.getId(), (Object)mock.getId())) continue;
                                bl = true;
                                break block4;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        mock.setState(MockState.DISABLED);
                        MockServiceImpl.access$getLog$p(this.this$0).warn("loadMock: mock: " + mock.getState() + ", obj: " + mock.hashCode());
                    }
                }
            }));
        }
    }

    @Override
    public void loadTraces(@NotNull TreeElement root, @Nullable File logDirectory) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        File file = logDirectory;
        Intrinsics.checkNotNull((Object)file);
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        root.setObj(new MockFolder(string, "", true));
        this.fillTree(root, logDirectory);
    }

    @Override
    public void loadTracesIfRequired(@NotNull String changedFile, @NotNull TreeElement root, @NotNull File logDirectory) {
        Intrinsics.checkNotNullParameter((Object)changedFile, (String)"changedFile");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)logDirectory, (String)"logDirectory");
        Path a = Paths.get(changedFile, new String[0]).normalize();
        Path b = Paths.get(logDirectory.getPath(), new String[0]).normalize();
        if (a.startsWith(b)) {
            this.fillTree(root, logDirectory);
        }
    }

    private final List<Mock> fillTree(TreeElement root, File dir) {
        List loaded;
        block2: {
            if (dir == null) {
                return new ArrayList();
            }
            root.getChildren().clear();
            loaded = new ArrayList();
            File[] fileArray = dir.listFiles();
            if (fileArray == null) break block2;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                this.scan(it, loaded, root, string);
            }
        }
        return loaded;
    }

    private final void scan(File $this$scan, List<Mock> loaded, TreeElement treeNode, String relativePath) {
        block5: {
            block4: {
                if (!$this$scan.exists()) {
                    return;
                }
                if (!$this$scan.isDirectory()) break block4;
                String newRP = relativePath + "/" + $this$scan.getName();
                String string = $this$scan.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                TreeElement newNode = new TreeElement(new MockFolder(string, newRP, true), null, 2, null);
                treeNode.getChildren().add(newNode);
                File[] fileArray = $this$scan.listFiles();
                if (fileArray == null) break block5;
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File it = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    this.scan(it, loaded, newNode, newRP);
                }
                break block5;
            }
            if (StringsKt.equals((String)FilesKt.getExtension((File)$this$scan), (String)"yaml", (boolean)true)) {
                String string = $this$scan.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                List<Mock> list = this.loadMock(string);
                loaded.addAll((Collection<Mock>)list);
                for (Mock item : list) {
                    TreeElement treeNode2 = new TreeElement(item, null, 2, null);
                    treeNode.getChildren().add(treeNode2);
                }
            }
        }
    }

    private final List<Mock> loadMock(String path) {
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path file = path2;
        return new MockParser(this.yamlReader).parse(file);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveMocks(@NotNull List<Mock> inputMocks) {
        Map mocksByFiles;
        Object value$iv$iv$iv;
        Iterable<Path> key$iv$iv;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(inputMocks, (String)"inputMocks");
        Iterable $this$groupBy$iv = inputMocks;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            Mock it = (Mock)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getFullMockPath();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$forEach$iv = mocksByFiles = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Map.Entry element$iv;
            Object element$iv$iv;
            Map.Entry pathAndMocks = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            Object $this$saveMocks_u24lambda_u248_u24lambda_u246 = element$iv$iv = CollectionsKt.createListBuilder();
            boolean $i$a$-buildList-MockServiceImpl$saveMocks$1$forSerializing$22 = false;
            key$iv$iv = this.mocks;
            Object $this$getOrPut$iv$iv$iv = $this$saveMocks_u24lambda_u248_u24lambda_u246;
            boolean $i$f$filter = false;
            value$iv$iv$iv = $this$filter$iv;
            Object destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                Mock m = (Mock)element$iv$iv2;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)m.getFullMockPath(), pathAndMocks.getKey())) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$getOrPut$iv$iv$iv.addAll((List)destination$iv$iv2);
            $this$saveMocks_u24lambda_u248_u24lambda_u246.removeIf(arg_0 -> MockServiceImpl.saveMocks$lambda$8$lambda$6$lambda$5((Function1)new Function1<Mock, Boolean>((Map.Entry<? extends Path, ? extends List<Mock>>)pathAndMocks){
                final /* synthetic */ Map.Entry<Path, List<Mock>> $pathAndMocks;
                {
                    this.$pathAndMocks = $pathAndMocks;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Mock it) {
                    boolean bl;
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Iterable $this$any$iv = this.$pathAndMocks.getValue();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                Mock m = (Mock)element$iv;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)m.getId(), (Object)it.getId())) continue;
                                bl = true;
                                break block3;
                            }
                            bl = false;
                        }
                    }
                    return bl;
                }
            }, arg_0));
            $this$saveMocks_u24lambda_u248_u24lambda_u246.addAll((Collection)pathAndMocks.getValue());
            List forSerializing2 = CollectionsKt.build((List)element$iv$iv);
            this.yamlWriter.writeYaml(forSerializing2, (Path)pathAndMocks.getKey());
            element$iv$iv = (Iterable)pathAndMocks.getValue();
            LoggerFacade loggerFacade = this.log;
            boolean $i$f$map = false;
            void $i$a$-buildList-MockServiceImpl$saveMocks$1$forSerializing$22 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                destination$iv$iv2 = (Mock)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl4 = false;
                collection.add(it.getId());
            }
            loggerFacade.info("Saved: " + (List)destination$iv$iv3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MockService.DeletingResult deleteMock(@NotNull Mock mock) {
        MockService.DeletingResult deletingResult;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mock, (String)"mock");
        Iterable $this$filter$iv = this.mocks;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Mock m = (Mock)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)m.getMockPath(), (Object)mock.getMockPath()) && Intrinsics.areEqual((Object)m.getMockFileName(), (Object)mock.getMockFileName()) && m != mock)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List mocksFromCurrentFile = (List)destination$iv$iv;
        this.mocks.remove(mock);
        if (mocksFromCurrentFile.isEmpty()) {
            Files.delete(mock.getFullMockPath());
            deletingResult = MockService.DeletingResult.FILE_DELETED;
        } else {
            this.yamlWriter.writeYaml(mocksFromCurrentFile, mock.getFullMockPath());
            deletingResult = MockService.DeletingResult.FILE_SAVED;
        }
        return deletingResult;
    }

    @Override
    @NotNull
    public Mock newMock(@NotNull String nodePath2) {
        Intrinsics.checkNotNullParameter((Object)nodePath2, (String)"nodePath");
        String fileName = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss")) + ".yaml";
        Path mockPath = this.nioFileAccessor.createFile(nodePath2, fileName);
        UUID uUID = UUID.randomUUID();
        String string = ((Object)mockPath.getParent()).toString();
        MockState mockState = MockState.ON_FLY;
        Intrinsics.checkNotNull((Object)uUID);
        Mock mock = new Mock(uUID, "", "<empty>", null, "SELECT 0", null, null, "", string, fileName, mockState, 104, null);
        this.mocks.add(mock);
        this.log.info("Created mock: " + mock.getId());
        this.saveMocks(CollectionsKt.listOf((Object)mock));
        return mock;
    }

    @Override
    @NotNull
    public String newMockDir(@NotNull String parentPath, @NotNull String nodePath2) {
        Intrinsics.checkNotNullParameter((Object)parentPath, (String)"parentPath");
        Intrinsics.checkNotNullParameter((Object)nodePath2, (String)"nodePath");
        return ((Object)this.fileAccessor.createDirs(parentPath + "/" + nodePath2)).toString();
    }

    private final void walk(TreeElement $this$walk, Function1<? super MockFolder, Unit> folderRun, Function1<? super Mock, Unit> mockRun) {
        TreeObject obj = $this$walk.getObj();
        if (obj instanceof MockFolder) {
            folderRun.invoke((Object)obj);
            Iterable $this$forEach$iv = $this$walk.getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TreeElement it = (TreeElement)element$iv;
                boolean bl = false;
                this.walk(it, folderRun, mockRun);
            }
        } else if (obj instanceof Mock) {
            mockRun.invoke((Object)obj);
        }
    }

    static /* synthetic */ void walk$default(MockServiceImpl mockServiceImpl, TreeElement treeElement, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = walk.1.INSTANCE;
        }
        if ((n & 2) != 0) {
            function12 = walk.2.INSTANCE;
        }
        mockServiceImpl.walk(treeElement, (Function1<? super MockFolder, Unit>)function1, (Function1<? super Mock, Unit>)function12);
    }

    private final List<MockFolder> collectFolders(TreeElement $this$collectFolders, Function1<? super MockFolder, Boolean> predicate) {
        List folders = new ArrayList();
        if ($this$collectFolders.getObj() instanceof MockFolder) {
            TreeObject treeObject = $this$collectFolders.getObj();
            Intrinsics.checkNotNull((Object)treeObject, (String)"null cannot be cast to non-null type com.btc.flowix.jbplugin.data.MockFolder");
            MockFolder mf = (MockFolder)treeObject;
            if (((Boolean)predicate.invoke((Object)mf)).booleanValue()) {
                folders.add(mf);
            }
            Iterable $this$forEach$iv = $this$collectFolders.getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TreeElement it = (TreeElement)element$iv;
                boolean bl = false;
                folders.addAll((Collection)this.collectFolders(it, predicate));
            }
        }
        return folders;
    }

    private final List<Mock> collectMocks(TreeElement $this$collectMocks, Function1<? super Mock, Boolean> predicate) {
        List mocks = new ArrayList();
        TreeObject obj = $this$collectMocks.getObj();
        if (obj instanceof Mock) {
            if (((Boolean)predicate.invoke((Object)obj)).booleanValue()) {
                mocks.add(obj);
            }
        } else if (obj instanceof MockFolder) {
            Iterable $this$forEach$iv = $this$collectMocks.getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TreeElement it = (TreeElement)element$iv;
                boolean bl = false;
                mocks.addAll((Collection)this.collectMocks(it, predicate));
            }
        }
        return mocks;
    }

    private static final boolean saveMocks$lambda$8$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ LoggerFacade access$getLog$p(MockServiceImpl $this) {
        return $this.log;
    }
}

