/*
 * Decompiled with CFR 0.152.
 */
package com.btc.flowix.jbplugin.data.serialization;

import com.btc.flowix.jbplugin.ProjectContext;
import com.btc.flowix.jbplugin.data.serialization.FileAccessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/btc/flowix/jbplugin/data/serialization/VirtualFileAccessor;", "Lcom/btc/flowix/jbplugin/data/serialization/FileAccessor;", "()V", "createDirs", "Ljava/nio/file/Path;", "fullPath", "", "createFile", "path", "fileName", "getContent", "writeContentToFile", "", "content", "flowixsql"})
public final class VirtualFileAccessor
implements FileAccessor {
    @Override
    @NotNull
    public String getContent(@NotNull Path path) {
        Document document;
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = path.toFile();
        VirtualFile virtualFile2 = virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        if (virtualFile2 == null) {
            throw new IllegalStateException(("file not found: " + file).toString());
        }
        Document document2 = document = FileDocumentManager.getInstance().getDocument(virtualFile2);
        String string = document2 != null ? document2.getText() : null;
        if (string == null) {
            throw new IllegalStateException(("document not found " + file).toString());
        }
        return string;
    }

    @Override
    @NotNull
    public Path createFile(@NotNull String path, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Ref.ObjectRef ret = new Ref.ObjectRef();
        WriteCommandAction.runWriteCommandAction((Project)ProjectContext.INSTANCE.getProject(), () -> VirtualFileAccessor.createFile$lambda$0(path, ret, this, fileName));
        Path path2 = (Path)ret.element;
        if (path2 == null) {
            Path path3 = Paths.get("", new String[0]);
            path2 = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        }
        return path2;
    }

    @Override
    @NotNull
    public Path createDirs(@NotNull String fullPath) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        Path it = path = FileAccessor.DefaultImpls.createDirs(this, fullPath);
        boolean bl = false;
        LocalFileSystem.getInstance().refreshAndFindFileByNioFile(it);
        return path;
    }

    @Override
    public void writeContentToFile(@NotNull Path path, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        System.out.println((Object)content);
        WriteCommandAction.runWriteCommandAction((Project)ProjectContext.INSTANCE.getProject(), () -> VirtualFileAccessor.writeContentToFile$lambda$2(path, content));
    }

    private static final void createFile$lambda$0(String $path, Ref.ObjectRef $ret, VirtualFileAccessor this$0, String $fileName) {
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        Intrinsics.checkNotNullParameter((Object)$ret, (String)"$ret");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$fileName, (String)"$fileName");
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath($path);
        if (virtualFile == null) {
            throw new IllegalStateException(("path " + $path + " not found").toString());
        }
        VirtualFile virtualPath = virtualFile;
        $ret.element = virtualPath.createChildData((Object)this$0, $fileName).toNioPath();
    }

    private static final void writeContentToFile$lambda$2(Path $path, String $content) {
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        Intrinsics.checkNotNullParameter((Object)$content, (String)"$content");
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(((Object)$path).toString());
        if (virtualFile == null) {
            throw new IllegalStateException(("path " + $path + " not found").toString());
        }
        VirtualFile virtualFile2 = virtualFile;
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
        if (document != null) {
            document.setText((CharSequence)$content);
        } else {
            String string = $content;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            virtualFile2.setBinaryContent(byArray);
        }
    }
}

