/*
 * Decompiled with CFR 0.152.
 */
package com.btc.flowix.jbplugin;

import com.btc.flowix.jbplugin.IJLogger;
import com.btc.flowix.jbplugin.LoggerFacade;
import com.btc.flowix.jbplugin.ProjectContext;
import com.btc.flowix.jbplugin.SoutLogger;
import com.btc.flowix.jbplugin.TopLevelKt;
import com.btc.flowix.jbplugin.listeners.Topics;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.Topic;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.util.NoSuchElementException;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/btc/flowix/jbplugin/Client;", "", "address", "", "(Ljava/lang/String;)V", "connection", "Ljava/net/Socket;", "log", "Lcom/btc/flowix/jbplugin/LoggerFacade;", "reader", "Ljava/util/Scanner;", "<set-?>", "", "ready", "getReady", "()Z", "writer", "Ljava/io/OutputStream;", "connect", "port", "", "read", "", "write", "message", "", "Companion", "flowixsql"})
@SourceDebugExtension(value={"SMAP\nClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Client.kt\ncom/btc/flowix/jbplugin/Client\n+ 2 TopLevel.kt\ncom/btc/flowix/jbplugin/TopLevelKt\n*L\n1#1,83:1\n73#2,5:84\n*S KotlinDebug\n*F\n+ 1 Client.kt\ncom/btc/flowix/jbplugin/Client\n*L\n23#1:84,5\n*E\n"})
public final class Client {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String address;
    private boolean ready;
    @Nullable
    private Socket connection;
    @Nullable
    private Scanner reader;
    @Nullable
    private OutputStream writer;
    @NotNull
    private final LoggerFacade log;
    private static final long RETRY_DELAY = 500L;
    private static final int MAX_RETRIES = 10;

    public Client(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.address = address;
        Client $this$getLogger$iv = this;
        boolean $i$f$getLogger = false;
        this.log = ApplicationManager.getApplication() != null ? (LoggerFacade)new IJLogger(Client.class) : (LoggerFacade)new SoutLogger(Client.class);
    }

    public final boolean getReady() {
        return this.connection != null && this.reader != null && this.writer != null;
    }

    public final boolean connect(int port) {
        int retryCount = 0;
        while (retryCount < 10) {
            try {
                Socket socket = this.connection = new Socket(this.address, port);
                Intrinsics.checkNotNull((Object)socket);
                this.reader = new Scanner(socket.getInputStream()).useDelimiter("\\|");
                Socket socket2 = this.connection;
                Intrinsics.checkNotNull((Object)socket2);
                this.writer = socket2.getOutputStream();
                this.log.info("Connected to server at " + this.address + " on port " + port);
                BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ Client this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                Client.access$read(this.this$0);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
                return true;
            }
            catch (ConnectException connectException) {
                Thread.sleep(500L);
                this.log.info("Retrying connection to " + this.address + ":" + port + " after " + ++retryCount + " retries");
            }
        }
        this.log.error("Could not connect to server after " + retryCount + " retries");
        return false;
    }

    public final void write(@NotNull byte[] message) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            OutputStream outputStream = this.writer;
            if (outputStream == null) break block0;
            outputStream.write(message);
        }
    }

    private final void read() {
        while (true) {
            try {
                String body;
                String type;
                Scanner scanner = this.reader;
                Intrinsics.checkNotNull((Object)scanner);
                String message = scanner.next();
                Intrinsics.checkNotNull((Object)message);
                Intrinsics.checkNotNullExpressionValue((Object)message.substring(0, 1), (String)"substring(...)");
                Intrinsics.checkNotNullExpressionValue((Object)message.substring(1), (String)"substring(...)");
                Object event = switch (type) {
                    case "L" -> Topics.INSTANCE.getUPDATE_LOADED_LIST_EVENT();
                    case "E" -> Topics.INSTANCE.getCORRUPTION_NOTICE_EVENT();
                    case "N" -> Topics.INSTANCE.getSERVER_NOTIFICATION_EVENT();
                    case "Q" -> Topics.INSTANCE.getSERVER_QUIT_EVENT();
                    default -> throw new IllegalStateException(("The client does not support message " + type).toString());
                };
                ApplicationManager.getApplication().invokeLater(() -> Client.read$lambda$0(event, body));
                this.log.debug("Received server message with type: " + type + " and body: " + body);
            }
            catch (NoSuchElementException noSuchElementException) {
                this.log.info("The server disconnected");
                Scanner scanner = this.reader;
                if (scanner != null) {
                    scanner.close();
                }
                OutputStream outputStream = this.writer;
                if (outputStream != null) {
                    outputStream.close();
                }
                return;
            }
        }
    }

    private static final void read$lambda$0(Topic $event, String $body) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
            Intrinsics.checkNotNullParameter((Object)$body, (String)"$body");
            Project project = ProjectContext.INSTANCE.getProject();
            if (project == null) break block0;
            TopLevelKt.submitEvent(project, $event, $body);
        }
    }

    public static final /* synthetic */ void access$read(Client $this) {
        $this.read();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/btc/flowix/jbplugin/Client$Companion;", "", "()V", "MAX_RETRIES", "", "RETRY_DELAY", "", "flowixsql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

