/*
 * Decompiled with CFR 0.152.
 */
package com.btc.flowix.jbplugin.services;

import com.btc.flowix.jbplugin.IJLogger;
import com.btc.flowix.jbplugin.LoggerFacade;
import com.btc.flowix.jbplugin.SoutLogger;
import com.btc.flowix.jbplugin.TopLevelKt;
import com.btc.flowix.jbplugin.actions.ToolbarState;
import com.btc.flowix.jbplugin.configuration.Keys;
import com.btc.flowix.jbplugin.data.Mock;
import com.btc.flowix.jbplugin.data.MockFolder;
import com.btc.flowix.jbplugin.data.MockState;
import com.btc.flowix.jbplugin.data.TreeObject;
import com.btc.flowix.jbplugin.data.serialization.VirtualFileAccessor;
import com.btc.flowix.jbplugin.listeners.Topics;
import com.btc.flowix.jbplugin.services.ConfigService;
import com.btc.flowix.jbplugin.services.ManagerService;
import com.btc.flowix.jbplugin.services.MockService;
import com.btc.flowix.jbplugin.services.MockServiceImpl;
import com.btc.flowix.jbplugin.ui.TreeElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\u0006\u0010\u0019\u001a\u00020\u0015J\b\u0010\u001a\u001a\u00020\u0015H\u0002J\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010!\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\"\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020 J\u000e\u0010%\u001a\u00020\u00172\u0006\u0010$\u001a\u00020 J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020 H\u0002J\u000e\u0010(\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010)\u001a\u00020\u0015J\b\u0010*\u001a\u00020\u0015H\u0002J\u0006\u0010+\u001a\u00020\u0015J\u000e\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u001dJ\u0016\u0010.\u001a\u00020\u00152\u0006\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020\u001dJ\u0012\u00101\u001a\b\u0012\u0004\u0012\u00020302*\u00020\u001dH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00064"}, d2={"Lcom/btc/flowix/jbplugin/services/FlowixService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "configService", "Lcom/btc/flowix/jbplugin/services/ConfigService;", "logger", "Lcom/btc/flowix/jbplugin/LoggerFacade;", "managerService", "Lcom/btc/flowix/jbplugin/services/ManagerService;", "mockService", "Lcom/btc/flowix/jbplugin/services/MockServiceImpl;", "process", "Ljava/lang/Process;", "<set-?>", "", "ready", "getReady", "()Z", "deleteMock", "", "mock", "Lcom/btc/flowix/jbplugin/data/Mock;", "dispose", "initialize", "killServer", "loadMocks", "root", "Lcom/btc/flowix/jbplugin/ui/TreeElement;", "loadMocksIfRequired", "changedFile", "", "loadTraces", "loadTracesIfRequired", "newFolder", "nodePath", "newMock", "reloadVirtualFile", "path", "saveMock", "start", "startServer", "stop", "switchState", "el", "updateLoadedMocks", "message", "node", "collectMockIds", "", "Ljava/util/UUID;", "flowixsql"})
@SourceDebugExtension(value={"SMAP\nFlowixService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlowixService.kt\ncom/btc/flowix/jbplugin/services/FlowixService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 TopLevel.kt\ncom/btc/flowix/jbplugin/TopLevelKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,209:1\n31#2,2:210\n31#2,2:212\n78#3,4:214\n1#4:218\n1368#5:219\n1454#5,5:220\n*S KotlinDebug\n*F\n+ 1 FlowixService.kt\ncom/btc/flowix/jbplugin/services/FlowixService\n*L\n29#1:210,2\n30#1:212,2\n33#1:214,4\n191#1:219\n191#1:220,5\n*E\n"})
public final class FlowixService
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final ConfigService configService;
    @NotNull
    private final ManagerService managerService;
    @NotNull
    private final MockServiceImpl mockService;
    @Nullable
    private Process process;
    @NotNull
    private final LoggerFacade logger;
    private boolean ready;

    public FlowixService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class serviceClass$iv = ConfigService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.configService = (ConfigService)object;
        $this$service$iv = (ComponentManager)this.project;
        $i$f$service = false;
        serviceClass$iv = ManagerService.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.managerService = (ManagerService)object2;
        this.mockService = new MockServiceImpl(new VirtualFileAccessor());
        FlowixService $this$getLogger$iv = this;
        boolean $i$f$getLogger = false;
        this.logger = ApplicationManager.getApplication() != null ? (LoggerFacade)new IJLogger(FlowixService.class) : (LoggerFacade)new SoutLogger(FlowixService.class);
        MessageBusConnection $this$_init__u24lambda_u244 = this.project.getMessageBus().connect();
        boolean bl = false;
        $this$_init__u24lambda_u244.subscribe(Topics.INSTANCE.getAPP_CONNECTED(), () -> FlowixService.lambda$4$lambda$0(this));
        $this$_init__u24lambda_u244.subscribe(Topics.INSTANCE.getAPP_DISCONNECTED(), () -> FlowixService.lambda$4$lambda$1(this));
        $this$_init__u24lambda_u244.subscribe(Topics.INSTANCE.getSERVER_QUIT_EVENT(), arg_0 -> FlowixService.lambda$4$lambda$2(this, arg_0));
        $this$_init__u24lambda_u244.subscribe(Topics.INSTANCE.getSERVER_NOTIFICATION_EVENT(), arg_0 -> FlowixService.lambda$4$lambda$3(this, arg_0));
    }

    public final boolean getReady() {
        return this.ready;
    }

    public final void initialize() {
        boolean success = this.configService.loadConfiguration();
        if (success) {
            this.configService.installServer();
        } else {
            TopLevelKt.notifyError(this.project, "Could not load configuration");
        }
    }

    public final void start() {
        boolean ready = this.configService.loadConfiguration();
        if (ready) {
            this.startServer();
        }
    }

    private final void startServer() {
        String jarPath = this.configService.getServerArtifactName();
        String[] stringArray = new String[]{"bin", "java"};
        String javaBin = ((Object)Paths.get(System.getProperty("java.home"), stringArray)).toString();
        SpreadBuilder spreadBuilder = new SpreadBuilder(5);
        spreadBuilder.add((Object)javaBin);
        spreadBuilder.addSpread((Object)this.configService.getJVMArguments());
        spreadBuilder.add((Object)"-jar");
        spreadBuilder.add((Object)jarPath);
        spreadBuilder.addSpread((Object)this.configService.getArguments());
        ProcessBuilder pb = new ProcessBuilder((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
        pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        pb.directory(new File(this.configService.getConfigPath()));
        this.process = pb.start();
        Thread printingHook = new Thread(() -> FlowixService.startServer$lambda$5(this));
        Runtime.getRuntime().addShutdownHook(printingHook);
    }

    public final void stop() {
        block0: {
            TopLevelKt.submitEvent(this.project, Topics.INSTANCE.getMOCK_TREE_CLEARING_EVENT());
            this.project.putUserData(Keys.INSTANCE.getTOOLBAR_STATE(), (Object)new ToolbarState(true, false));
            TopLevelKt.refreshToolbar(this.project);
            Process process = this.process;
            if (process == null) break block0;
            process.destroy();
        }
    }

    public final void updateLoadedMocks(@NotNull String message, @NotNull TreeElement node) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.mockService.updateLoadedMocks(message, node);
    }

    public final void loadMocks(@NotNull TreeElement root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.mockService.loadMocks(root, this.configService.getMockDirectory());
    }

    public final void loadMocksIfRequired(@NotNull String changedFile, @NotNull TreeElement root) {
        Intrinsics.checkNotNullParameter((Object)changedFile, (String)"changedFile");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.mockService.loadMocksIfRequired(changedFile, root, this.configService.getMockDirectory());
    }

    public final void loadTraces(@NotNull TreeElement root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.mockService.loadTraces(root, this.configService.getLogDirectory());
    }

    public final void loadTracesIfRequired(@NotNull String changedFile, @NotNull TreeElement root) {
        Intrinsics.checkNotNullParameter((Object)changedFile, (String)"changedFile");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.mockService.loadTracesIfRequired(changedFile, root, this.configService.getLogDirectory());
    }

    public final void saveMock(@NotNull Mock mock) {
        Intrinsics.checkNotNullParameter((Object)mock, (String)"mock");
        this.mockService.saveMock(mock);
        Path path = Paths.get(mock.getMockPath() + "/" + mock.getCsvFile(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path csvPath = path;
        if (!Files.exists(csvPath, new LinkOption[0]) && mock.getCsvFile() != null) {
            Files.createFile(csvPath, new FileAttribute[0]);
            TopLevelKt.notifyInfo(this.project, "Created " + csvPath.getFileName());
        }
        this.reloadVirtualFile(((Object)mock.getFullMockPath()).toString());
        if (!Intrinsics.areEqual((Object)mock.getFullMockPath(), (Object)mock.getStartFullMockPath())) {
            this.reloadVirtualFile(((Object)mock.getStartFullMockPath()).toString());
        }
        TopLevelKt.notifyInfo(this.project, "Saved " + mock.getMockFileName());
    }

    public final void deleteMock(@NotNull Mock mock) {
        Intrinsics.checkNotNullParameter((Object)mock, (String)"mock");
        MockService.DeletingResult result = this.mockService.deleteMock(mock);
        switch (WhenMappings.$EnumSwitchMapping$0[result.ordinal()]) {
            case 1: {
                TopLevelKt.notifyInfo(this.project, "Saved " + mock.getMockFileName());
                this.reloadVirtualFile(((Object)mock.getStartFullMockPath()).toString());
                break;
            }
            case 2: {
                TopLevelKt.notifyInfo(this.project, "Deleted " + mock.getMockFileName());
            }
        }
        this.logger.info("removed mock: " + mock.getId());
    }

    @NotNull
    public final Mock newMock(@NotNull String nodePath2) {
        Mock mock;
        Intrinsics.checkNotNullParameter((Object)nodePath2, (String)"nodePath");
        String path = this.configService.getMockDirectory().getParent() + "/" + nodePath2;
        Mock it = mock = this.mockService.newMock(path);
        boolean bl = false;
        TopLevelKt.notifyInfo(this.project, "Created mock: " + it.getId());
        return mock;
    }

    @NotNull
    public final String newFolder(@NotNull String nodePath2) {
        Intrinsics.checkNotNullParameter((Object)nodePath2, (String)"nodePath");
        String string = this.configService.getMockDirectory().getParent();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParent(...)");
        return this.mockService.newMockDir(string, nodePath2);
    }

    private final void reloadVirtualFile(String path) {
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl("file://" + path);
        if (virtualFile != null) {
            ApplicationManager.getApplication().invokeLater(() -> FlowixService.reloadVirtualFile$lambda$8(virtualFile));
        }
    }

    public final void switchState(@NotNull TreeElement el) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)el, (String)"el");
        TreeObject ob = el.getObj();
        if (ob instanceof MockFolder) {
            bl = ((MockFolder)ob).getEnabled();
        } else if (ob instanceof Mock) {
            bl = ((Mock)ob).getState() == MockState.ON_FLY;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        boolean enabled = bl;
        this.mockService.switchState(el, !enabled);
        List<UUID> ids2 = this.collectMockIds(el);
        if (enabled) {
            this.managerService.disableMocks(ids2);
        } else {
            this.managerService.enableMocks(ids2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<UUID> collectMockIds(TreeElement $this$collectMockIds) {
        List list;
        TreeObject ob = $this$collectMockIds.getObj();
        if (ob instanceof Mock) {
            list = CollectionsKt.listOf((Object)((Mock)ob).getId());
        } else if (ob instanceof MockFolder) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = $this$collectMockIds.getChildren();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List<UUID> list2;
                TreeElement el = (TreeElement)element$iv$iv;
                boolean bl = false;
                TreeObject sub = el.getObj();
                if (sub instanceof Mock) {
                    list2 = CollectionsKt.listOf((Object)((Mock)sub).getId());
                } else if (sub instanceof MockFolder) {
                    list2 = this.collectMockIds(el);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                Iterable list$iv$iv = list2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    private final void killServer() {
        block0: {
            this.logger.info("Destroying the server process...");
            Process process = this.process;
            if (process == null) break block0;
            process.destroy();
        }
    }

    public void dispose() {
        this.killServer();
    }

    private static final void lambda$4$lambda$0(FlowixService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.ready = true;
    }

    private static final void lambda$4$lambda$1(FlowixService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.ready = false;
    }

    private static final void lambda$4$lambda$2(FlowixService this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.ready = false;
        this$0.stop();
    }

    private static final void lambda$4$lambda$3(FlowixService this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean error = StringsKt.first((CharSequence)it) == 'E';
        String string = it.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String body = string;
        if (error) {
            TopLevelKt.notifyError(this$0.project, body);
        } else {
            TopLevelKt.notifyInfo(this$0.project, body);
        }
    }

    private static final void startServer$lambda$5(FlowixService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.killServer();
    }

    private static final void reloadVirtualFile$lambda$8$lambda$7(VirtualFile $virtualFile) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager docManager = fileDocumentManager;
        Document document = docManager.getCachedDocument($virtualFile);
        if (document != null) {
            docManager.reloadFromDisk(document);
        }
        $virtualFile.refresh(false, false);
    }

    private static final void reloadVirtualFile$lambda$8(VirtualFile $virtualFile) {
        ApplicationManager.getApplication().runWriteAction(() -> FlowixService.reloadVirtualFile$lambda$8$lambda$7($virtualFile));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MockService.DeletingResult.values().length];
            try {
                nArray[MockService.DeletingResult.FILE_SAVED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MockService.DeletingResult.FILE_DELETED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

