/*
 * Decompiled with CFR 0.152.
 */
package com.btc.flowix.jbplugin.configuration;

import com.btc.flowix.jbplugin.IJLogger;
import com.btc.flowix.jbplugin.LoggerFacade;
import com.btc.flowix.jbplugin.SoutLogger;
import com.btc.flowix.jbplugin.TopLevelKt;
import com.btc.flowix.jbplugin.configuration.ServerInstaller;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/btc/flowix/jbplugin/configuration/NetworkServerInstaller;", "Lcom/btc/flowix/jbplugin/configuration/ServerInstaller;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "jarLocationHost", "", "jarLocationPort", "", "logger", "Lcom/btc/flowix/jbplugin/LoggerFacade;", "install", "", "jarPath", "artifactName", "flowixsql"})
@SourceDebugExtension(value={"SMAP\nNetworkServerInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkServerInstaller.kt\ncom/btc/flowix/jbplugin/configuration/NetworkServerInstaller\n+ 2 TopLevel.kt\ncom/btc/flowix/jbplugin/TopLevelKt\n*L\n1#1,43:1\n78#2,4:44\n*S KotlinDebug\n*F\n+ 1 NetworkServerInstaller.kt\ncom/btc/flowix/jbplugin/configuration/NetworkServerInstaller\n*L\n16#1:44,4\n*E\n"})
public final class NetworkServerInstaller
implements ServerInstaller {
    @NotNull
    private final Project project;
    @NotNull
    private final String jarLocationHost;
    private final int jarLocationPort;
    @NotNull
    private final LoggerFacade logger;

    public NetworkServerInstaller(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        String string = System.getenv("JAR_LOCATION_HOST");
        if (string == null) {
            string = "localhost";
        }
        this.jarLocationHost = string;
        String string2 = System.getenv("JAR_LOCATION_PORT");
        this.jarLocationPort = string2 != null ? Integer.parseInt(string2) : 8000;
        NetworkServerInstaller $this$getLogger$iv = this;
        boolean $i$f$getLogger = false;
        this.logger = ApplicationManager.getApplication() != null ? (LoggerFacade)new IJLogger(NetworkServerInstaller.class) : (LoggerFacade)new SoutLogger(NetworkServerInstaller.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void install(@NotNull String jarPath, @NotNull String artifactName) {
        Intrinsics.checkNotNullParameter((Object)jarPath, (String)"jarPath");
        Intrinsics.checkNotNullParameter((Object)artifactName, (String)"artifactName");
        Closeable closeable = (Closeable)HttpClients.createDefault();
        Throwable throwable = null;
        try {
            boolean response22;
            CloseableHttpClient it = (CloseableHttpClient)closeable;
            boolean bl = false;
            String[] stringArray = new String[]{artifactName};
            Path path = Paths.get(jarPath, Arrays.copyOf(stringArray, stringArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path jarFile = path;
            FileOutputStream out = new FileOutputStream(jarFile.toFile());
            try {
                boolean bl2;
                CloseableHttpResponse response22 = it.execute(new HttpHost(this.jarLocationHost, this.jarLocationPort), (HttpRequest)new HttpGet("/file"));
                if (response22.getStatusLine().getStatusCode() == 200) {
                    response22.getEntity().writeTo((OutputStream)out);
                    out.close();
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                response22 = bl2;
            }
            catch (Exception e) {
                this.logger.warn("Failed to connect to server at " + this.jarLocationHost + ":" + this.jarLocationPort);
                response22 = false;
            }
            boolean result = response22;
            if (!result) {
                String errMsg = "Failed to load a server JAR file to path: " + jarPath;
                this.logger.warn(errMsg);
                TopLevelKt.notifyError(this.project, errMsg);
                out.close();
                Files.delete(jarFile);
                return;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

