/*
 * Decompiled with CFR 0.152.
 */
package com.btc.flowix.jbplugin.services;

import com.btc.flowix.jbplugin.Client;
import com.btc.flowix.jbplugin.Command;
import com.btc.flowix.jbplugin.IJLogger;
import com.btc.flowix.jbplugin.LoggerFacade;
import com.btc.flowix.jbplugin.SoutLogger;
import com.btc.flowix.jbplugin.TopLevelKt;
import com.btc.flowix.jbplugin.internal.UtilsKt;
import com.btc.flowix.jbplugin.listeners.Topics;
import com.btc.flowix.jbplugin.services.ConfigService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\u0006\u0010\u0014\u001a\u00020\u000eJ\u0014\u0010\u0015\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u001c\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0006\u0010\u001b\u001a\u00020\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/btc/flowix/jbplugin/services/ManagerService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "client", "Lcom/btc/flowix/jbplugin/Client;", "configService", "Lcom/btc/flowix/jbplugin/services/ConfigService;", "log", "Lcom/btc/flowix/jbplugin/LoggerFacade;", "connect", "", "disableLog", "", "disableMocks", "ids", "", "Ljava/util/UUID;", "dispose", "enableLog", "enableMocks", "sendCmd", "cmd", "Lcom/btc/flowix/jbplugin/Command;", "data", "", "stopServer", "flowixsql"})
@SourceDebugExtension(value={"SMAP\nManagerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManagerService.kt\ncom/btc/flowix/jbplugin/services/ManagerService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 TopLevel.kt\ncom/btc/flowix/jbplugin/TopLevelKt\n*L\n1#1,93:1\n31#2,2:94\n78#3,4:96\n*S KotlinDebug\n*F\n+ 1 ManagerService.kt\ncom/btc/flowix/jbplugin/services/ManagerService\n*L\n19#1:94,2\n21#1:96,4\n*E\n"})
public final class ManagerService
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final ConfigService configService;
    @NotNull
    private Client client;
    @NotNull
    private final LoggerFacade log;

    public ManagerService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ConfigService> serviceClass$iv = ConfigService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.configService = (ConfigService)object;
        this.client = new Client("localhost");
        ManagerService $this$getLogger$iv = this;
        boolean $i$f$getLogger = false;
        this.log = ApplicationManager.getApplication() != null ? (LoggerFacade)new IJLogger(ManagerService.class) : (LoggerFacade)new SoutLogger(ManagerService.class);
    }

    public final boolean connect() {
        boolean bl;
        boolean it = bl = this.client.connect(this.configService.getManagePort());
        boolean bl2 = false;
        TopLevelKt.submitEvent(this.project, Topics.INSTANCE.getAPP_CONNECTED());
        return bl;
    }

    public final void enableLog() {
        ManagerService.sendCmd$default(this, Command.LOG, null, 2, null);
    }

    public final void disableLog() {
        ManagerService.sendCmd$default(this, Command.LOG_STOP, null, 2, null);
    }

    public final void stopServer() {
        TopLevelKt.submitEvent(this.project, Topics.INSTANCE.getAPP_DISCONNECTED());
        ManagerService.sendCmd$default(this, Command.QUIT, null, 2, null);
    }

    public final void enableMocks(@NotNull List<UUID> ids2) {
        Intrinsics.checkNotNullParameter(ids2, (String)"ids");
        this.sendCmd(Command.INCLUDE_MOCKS, new ObjectMapper().writeValueAsString(ids2));
    }

    public final void disableMocks(@NotNull List<UUID> ids2) {
        Intrinsics.checkNotNullParameter(ids2, (String)"ids");
        this.sendCmd(Command.EXCLUDE_MOCKS, new ObjectMapper().writeValueAsString(ids2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void sendCmd(Command cmd, String data) {
        if (!this.client.getReady()) {
            throw new IllegalStateException("Management connection not ready");
        }
        this.log.debug("Sending management message from client: cmd=" + cmd + ", data=" + data);
        switch (WhenMappings.$EnumSwitchMapping$0[cmd.ordinal()]) {
            case 1: {
                byte[] bytes = new byte[5];
                bytes[0] = 81;
                this.client.write(bytes);
                return;
            }
            case 2: {
                byte[] bytes = new byte[5];
                bytes[0] = 108;
                this.client.write(bytes);
                return;
            }
            case 3: {
                byte[] bytes = new byte[5];
                bytes[0] = 76;
                this.client.write(bytes);
                return;
            }
            case 4: {
                Object object = data;
                if (object == null) throw new IllegalArgumentException("data can't be null for <I> message");
                byte[] byArray = StringsKt.encodeToByteArray((String)object);
                object = byArray;
                if (byArray == null) {
                    throw new IllegalArgumentException("data can't be null for <I> message");
                }
                Object body = object;
                byte[] header = new byte[5];
                header[0] = 73;
                UtilsKt.int4(header, 1, ((Object)body).length);
                this.client.write(header);
                this.client.write((byte[])body);
                return;
            }
            case 5: {
                Object object = data;
                if (object == null) throw new IllegalArgumentException("data can't be null for <E> message");
                byte[] byArray = StringsKt.encodeToByteArray((String)object);
                object = byArray;
                if (byArray == null) {
                    throw new IllegalArgumentException("data can't be null for <E> message");
                }
                Object body = object;
                byte[] header = new byte[5];
                header[0] = 69;
                UtilsKt.int4(header, 1, ((Object)body).length);
                this.client.write(header);
                this.client.write((byte[])body);
            }
        }
    }

    static /* synthetic */ void sendCmd$default(ManagerService managerService, Command command, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        managerService.sendCmd(command, string);
    }

    public void dispose() {
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Command.values().length];
            try {
                nArray[Command.QUIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Command.LOG_STOP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Command.LOG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Command.INCLUDE_MOCKS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Command.EXCLUDE_MOCKS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

