/*
 * Decompiled with CFR 0.152.
 */
package com.btc.flowixsql.services;

import com.btc.flowixsql.IJLogger;
import com.btc.flowixsql.LoggerFacade;
import com.btc.flowixsql.SoutLogger;
import com.btc.flowixsql.TopLevelKt;
import com.btc.flowixsql.data.Mock;
import com.btc.flowixsql.data.MockFolder;
import com.btc.flowixsql.data.MockState;
import com.btc.flowixsql.data.serialization.FileAccessor;
import com.btc.flowixsql.data.serialization.JacksonYamlWriter;
import com.btc.flowixsql.data.serialization.MockParser;
import com.btc.flowixsql.data.serialization.NioFileAccessor;
import com.btc.flowixsql.data.serialization.SnakeYamlReader;
import com.btc.flowixsql.data.serialization.YamlReader;
import com.btc.flowixsql.data.serialization.YamlWriter;
import com.btc.flowixsql.services.MockService;
import com.btc.flowixsql.services.MockServiceImpl;
import com.btc.flowixsql.ui.TreeElement;
import com.fasterxml.jackson.core.type.TypeReference;
import com.intellij.openapi.application.ApplicationManager;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0016J \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001a\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u0017H\u0016J \u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\u001a\u0010 \u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010!\u001a\u0004\u0018\u00010\u0017H\u0016J \u0010\"\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0017H\u0016J\u0010\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u001bH\u0016J\u0018\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001bH\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u0015H\u0016J\u0018\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u0015H\u0016J&\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u0019*\u00020\u00152\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020100H\u0002J&\u00102\u001a\b\u0012\u0004\u0012\u00020\t0\u0019*\u00020\u00152\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020100H\u0002J*\u00103\u001a\u00020(*\u00020\u00172\f\u00104\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u00105\u001a\u00020\u00152\u0006\u00106\u001a\u00020\u001bH\u0002J\u0014\u0010)\u001a\u00020\u0015*\u00020\u00152\u0006\u00107\u001a\u000201H\u0002J8\u00108\u001a\u00020(*\u00020\u00152\u0014\b\u0002\u00109\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020(002\u0014\b\u0002\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020(00H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/btc/flowixsql/services/MockServiceImpl;", "Lcom/btc/flowixsql/services/MockService;", "fileAccessor", "Lcom/btc/flowixsql/data/serialization/FileAccessor;", "(Lcom/btc/flowixsql/data/serialization/FileAccessor;)V", "log", "Lcom/btc/flowixsql/LoggerFacade;", "mocks", "", "Lcom/btc/flowixsql/data/Mock;", "nioFileAccessor", "Lcom/btc/flowixsql/data/serialization/NioFileAccessor;", "yamlReader", "Lcom/btc/flowixsql/data/serialization/YamlReader;", "yamlWriter", "Lcom/btc/flowixsql/data/serialization/YamlWriter;", "deleteMock", "Lcom/btc/flowixsql/services/MockService$DeletingResult;", "mock", "fillTree", "root", "Lcom/btc/flowixsql/ui/TreeElement;", "dir", "Ljava/io/File;", "loadMock", "", "path", "", "loadMocks", "mockDirectory", "loadMocksIfRequired", "changedFile", "loadTraces", "logDirectory", "loadTracesIfRequired", "newMock", "nodePath", "newMockDir", "parentPath", "saveMock", "", "switchState", "node", "updateLoadedMocks", "message", "collectFolders", "Lcom/btc/flowixsql/data/MockFolder;", "predicate", "Lkotlin/Function1;", "", "collectMocks", "scan", "loaded", "treeNode", "relativePath", "enabled", "walk", "folderRun", "mockRun", "flowixsql"})
@SourceDebugExtension(value={"SMAP\nMockServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockServiceImpl.kt\ncom/btc/flowixsql/services/MockServiceImpl\n+ 2 TopLevel.kt\ncom/btc/flowixsql/TopLevelKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,215:1\n72#2,4:216\n1863#3,2:220\n774#3:226\n865#3,2:227\n774#3:229\n865#3,2:230\n774#3:232\n865#3,2:233\n1863#3,2:235\n1863#3,2:237\n1863#3,2:239\n13409#4,2:222\n13409#4,2:224\n*S KotlinDebug\n*F\n+ 1 MockServiceImpl.kt\ncom/btc/flowixsql/services/MockServiceImpl\n*L\n24#1:216,4\n47#1:220,2\n137#1:226\n137#1:227,2\n145#1:229\n145#1:230,2\n152#1:232\n152#1:233,2\n183#1:235,2\n195#1:237,2\n209#1:239,2\n104#1:222,2\n116#1:224,2\n*E\n"})
public final class MockServiceImpl
implements MockService {
    @NotNull
    private final FileAccessor fileAccessor;
    @NotNull
    private final List<Mock> mocks;
    @NotNull
    private final NioFileAccessor nioFileAccessor;
    @NotNull
    private final YamlReader yamlReader;
    @NotNull
    private final YamlWriter yamlWriter;
    @NotNull
    private final LoggerFacade log;

    public MockServiceImpl(@NotNull FileAccessor fileAccessor) {
        Intrinsics.checkNotNullParameter((Object)fileAccessor, (String)"fileAccessor");
        this.fileAccessor = fileAccessor;
        this.mocks = new ArrayList();
        this.nioFileAccessor = new NioFileAccessor();
        this.yamlReader = new SnakeYamlReader(this.fileAccessor);
        this.yamlWriter = new JacksonYamlWriter(this.nioFileAccessor);
        MockServiceImpl $this$getLogger$iv = this;
        boolean $i$f$getLogger = false;
        this.log = ApplicationManager.getApplication() != null ? (LoggerFacade)new IJLogger(MockServiceImpl.class) : (LoggerFacade)new SoutLogger(MockServiceImpl.class);
    }

    @Override
    public void updateLoadedMocks(@NotNull String message, @NotNull TreeElement node) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        List ids2 = (List)TopLevelKt.deserializeJson(message, (TypeReference)new TypeReference<List<? extends UUID>>(){});
        MockServiceImpl.walk$default(this, node, null, (Function1)new Function1<Mock, Unit>((List<UUID>)ids2){
            final /* synthetic */ List<UUID> $ids;
            {
                this.$ids = $ids;
                super(1);
            }

            public final void invoke(@NotNull Mock mock) {
                Intrinsics.checkNotNullParameter((Object)mock, (String)"mock");
                mock.setState(mock.getState() == MockState.DISABLED ? MockState.DISABLED : (this.$ids.contains(mock.getId()) ? MockState.ON_FLY : MockState.CORRUPTED));
            }
        }, 1, null);
    }

    @Override
    @NotNull
    public TreeElement switchState(@NotNull TreeElement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Object object = node.getObj();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.btc.flowixsql.data.MockFolder");
        MockFolder mf = (MockFolder)object;
        return this.switchState(node, !mf.getEnabled());
    }

    private final TreeElement switchState(TreeElement $this$switchState, boolean enabled) {
        Object object = $this$switchState.getObj();
        if (object instanceof MockFolder) {
            Object object2 = $this$switchState.getObj();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.btc.flowixsql.data.MockFolder");
            MockFolder mockFolder = (MockFolder)object2;
            mockFolder.setEnabled(enabled);
            Iterable $this$forEach$iv = $this$switchState.getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TreeElement it = (TreeElement)element$iv;
                boolean bl = false;
                this.switchState(it, enabled);
            }
        } else if (object instanceof Mock) {
            Object object3 = $this$switchState.getObj();
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type com.btc.flowixsql.data.Mock");
            ((Mock)object3).setState(enabled ? MockState.ON_FLY : MockState.DISABLED);
        }
        return $this$switchState;
    }

    @Override
    @NotNull
    public TreeElement loadMocks(@NotNull TreeElement root, @Nullable File mockDirectory) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        File file = mockDirectory;
        Intrinsics.checkNotNull((Object)file);
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        root.setObj(new MockFolder(string, "", true));
        this.mocks.clear();
        this.mocks.addAll((Collection<Mock>)this.fillTree(root, mockDirectory));
        return root;
    }

    @Override
    @NotNull
    public TreeElement loadMocksIfRequired(@NotNull String changedFile, @NotNull TreeElement root, @NotNull File mockDirectory) {
        Intrinsics.checkNotNullParameter((Object)changedFile, (String)"changedFile");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)mockDirectory, (String)"mockDirectory");
        Path a = Paths.get(changedFile, new String[0]).normalize();
        Path b = Paths.get(mockDirectory.getPath(), new String[0]).normalize();
        if (a.startsWith(b)) {
            List<MockFolder> disabledFolders2 = this.collectFolders(root, (Function1<? super MockFolder, Boolean>)((Function1)loadMocksIfRequired.disabledFolders.1.INSTANCE));
            List<Mock> disabledMocks2 = this.collectMocks(root, (Function1<? super Mock, Boolean>)((Function1)loadMocksIfRequired.disabledMocks.1.INSTANCE));
            this.mocks.clear();
            this.mocks.addAll((Collection<Mock>)this.fillTree(root, mockDirectory));
            this.walk(root, (Function1<? super MockFolder, Unit>)((Function1)new Function1<MockFolder, Unit>(disabledFolders2){
                final /* synthetic */ List<MockFolder> $disabledFolders;
                {
                    this.$disabledFolders = $disabledFolders;
                    super(1);
                }

                public final void invoke(@NotNull MockFolder folder) {
                    boolean bl;
                    block4: {
                        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
                        Iterable $this$any$iv = this.$disabledFolders;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                MockFolder df = (MockFolder)element$iv;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)df.getPath(), (Object)folder.getPath())) continue;
                                bl = true;
                                break block4;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        folder.setEnabled(false);
                    }
                }
            }), (Function1<? super Mock, Unit>)((Function1)new Function1<Mock, Unit>(disabledMocks2, this){
                final /* synthetic */ List<Mock> $disabledMocks;
                final /* synthetic */ MockServiceImpl this$0;
                {
                    this.$disabledMocks = $disabledMocks;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Mock mock) {
                    boolean bl;
                    block4: {
                        Intrinsics.checkNotNullParameter((Object)mock, (String)"mock");
                        Iterable $this$any$iv = this.$disabledMocks;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                Mock dm = (Mock)element$iv;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)dm.getId(), (Object)mock.getId())) continue;
                                bl = true;
                                break block4;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        mock.setState(MockState.DISABLED);
                        MockServiceImpl.access$getLog$p(this.this$0).warn("loadMock: mock: " + mock.getState() + ", obj: " + mock.hashCode());
                    }
                }
            }));
        }
        return root;
    }

    @Override
    @NotNull
    public TreeElement loadTraces(@NotNull TreeElement root, @Nullable File logDirectory) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        File file = logDirectory;
        Intrinsics.checkNotNull((Object)file);
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        root.setObj(new MockFolder(string, "", true));
        this.fillTree(root, logDirectory);
        return root;
    }

    @Override
    @NotNull
    public TreeElement loadTracesIfRequired(@NotNull String changedFile, @NotNull TreeElement root, @NotNull File logDirectory) {
        Intrinsics.checkNotNullParameter((Object)changedFile, (String)"changedFile");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)logDirectory, (String)"logDirectory");
        Path a = Paths.get(changedFile, new String[0]).normalize();
        Path b = Paths.get(logDirectory.getPath(), new String[0]).normalize();
        if (a.startsWith(b)) {
            this.fillTree(root, logDirectory);
        }
        return root;
    }

    private final List<Mock> fillTree(TreeElement root, File dir) {
        List loaded;
        block2: {
            if (dir == null) {
                return new ArrayList();
            }
            root.getChildren().clear();
            loaded = new ArrayList();
            File[] fileArray = dir.listFiles();
            if (fileArray == null) break block2;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                this.scan(it, loaded, root, string);
            }
        }
        return loaded;
    }

    private final void scan(File $this$scan, List<Mock> loaded, TreeElement treeNode, String relativePath) {
        block5: {
            block4: {
                if (!$this$scan.exists()) {
                    return;
                }
                if (!$this$scan.isDirectory()) break block4;
                String newRP = relativePath + "/" + $this$scan.getName();
                String string = $this$scan.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                TreeElement newNode = new TreeElement(new MockFolder(string, newRP, true), null, 2, null);
                treeNode.getChildren().add(newNode);
                File[] fileArray = $this$scan.listFiles();
                if (fileArray == null) break block5;
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File it = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    this.scan(it, loaded, newNode, newRP);
                }
                break block5;
            }
            if (StringsKt.equals((String)FilesKt.getExtension((File)$this$scan), (String)"yaml", (boolean)true)) {
                String string = $this$scan.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                List<Mock> list = this.loadMock(string);
                loaded.addAll((Collection<Mock>)list);
                for (Mock item : list) {
                    TreeElement treeNode2 = new TreeElement(item, null, 2, null);
                    treeNode.getChildren().add(treeNode2);
                }
            }
        }
    }

    private final List<Mock> loadMock(String path) {
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path file = path2;
        return new MockParser(this.yamlReader).parse(file);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveMock(@NotNull Mock mock) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List list;
        Intrinsics.checkNotNullParameter((Object)mock, (String)"mock");
        List $this$saveMock_u24lambda_u245 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable iterable = this.mocks;
        List list2 = $this$saveMock_u24lambda_u245;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Mock m = (Mock)element$iv$iv;
            boolean bl2 = false;
            if (!(Intrinsics.areEqual((Object)m.getMockPath(), (Object)mock.getMockPath()) && Intrinsics.areEqual((Object)m.getMockFileName(), (Object)mock.getMockFileName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list2.addAll((List)destination$iv$iv);
        $this$saveMock_u24lambda_u245.removeIf(arg_0 -> MockServiceImpl.saveMock$lambda$5$lambda$4((Function1)new Function1<Mock, Boolean>(mock){
            final /* synthetic */ Mock $mock;
            {
                this.$mock = $mock;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Mock it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getId(), (Object)this.$mock.getId());
            }
        }, arg_0));
        $this$saveMock_u24lambda_u245.add(mock);
        List forSerializing2 = CollectionsKt.build((List)list);
        this.yamlWriter.writeYaml(forSerializing2, mock.getFullMockPath());
        this.log.info("Saved: " + mock.getId());
        if (!Intrinsics.areEqual((Object)mock.getFullMockPath(), (Object)mock.getStartFullMockPath())) {
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2 = this.mocks;
            boolean $i$f$filter2 = false;
            $this$filter$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Mock m = (Mock)element$iv$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)m.getFullMockPath(), (Object)mock.getStartFullMockPath())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List mockFromOldFile = (List)destination$iv$iv2;
            this.yamlWriter.writeYaml(mockFromOldFile, mock.getStartFullMockPath());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MockService.DeletingResult deleteMock(@NotNull Mock mock) {
        MockService.DeletingResult deletingResult;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mock, (String)"mock");
        Iterable $this$filter$iv = this.mocks;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Mock m = (Mock)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)m.getMockPath(), (Object)mock.getMockPath()) && Intrinsics.areEqual((Object)m.getMockFileName(), (Object)mock.getMockFileName()) && m != mock)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List mocksFromCurrentFile = (List)destination$iv$iv;
        this.mocks.remove(mock);
        if (mocksFromCurrentFile.isEmpty()) {
            Files.delete(mock.getFullMockPath());
            deletingResult = MockService.DeletingResult.FILE_DELETED;
        } else {
            this.yamlWriter.writeYaml(mocksFromCurrentFile, mock.getFullMockPath());
            deletingResult = MockService.DeletingResult.FILE_SAVED;
        }
        return deletingResult;
    }

    @Override
    @NotNull
    public Mock newMock(@NotNull String nodePath2) {
        Intrinsics.checkNotNullParameter((Object)nodePath2, (String)"nodePath");
        String fileName = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss")) + ".yaml";
        Path mockPath = this.nioFileAccessor.createFile(nodePath2, fileName);
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        Mock mock = new Mock(uUID, "<empty>", null, "SELECT 0", null, null, ((Object)mockPath.getParent()).toString(), fileName, MockState.ON_FLY, 52, null);
        this.mocks.add(mock);
        this.log.info("Created mock: " + mock.getId());
        this.saveMock(mock);
        return mock;
    }

    @Override
    @NotNull
    public String newMockDir(@NotNull String parentPath, @NotNull String nodePath2) {
        Intrinsics.checkNotNullParameter((Object)parentPath, (String)"parentPath");
        Intrinsics.checkNotNullParameter((Object)nodePath2, (String)"nodePath");
        return ((Object)this.fileAccessor.createDirs(parentPath + "/" + nodePath2)).toString();
    }

    private final void walk(TreeElement $this$walk, Function1<? super MockFolder, Unit> folderRun, Function1<? super Mock, Unit> mockRun) {
        Object object = $this$walk.getObj();
        if (object instanceof MockFolder) {
            Object object2 = $this$walk.getObj();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.btc.flowixsql.data.MockFolder");
            folderRun.invoke((Object)((MockFolder)object2));
            Iterable $this$forEach$iv = $this$walk.getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TreeElement it = (TreeElement)element$iv;
                boolean bl = false;
                this.walk(it, folderRun, mockRun);
            }
        } else if (object instanceof Mock) {
            Object object3 = $this$walk.getObj();
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type com.btc.flowixsql.data.Mock");
            mockRun.invoke((Object)((Mock)object3));
        }
    }

    static /* synthetic */ void walk$default(MockServiceImpl mockServiceImpl, TreeElement treeElement, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = walk.1.INSTANCE;
        }
        if ((n & 2) != 0) {
            function12 = walk.2.INSTANCE;
        }
        mockServiceImpl.walk(treeElement, (Function1<? super MockFolder, Unit>)function1, (Function1<? super Mock, Unit>)function12);
    }

    private final List<MockFolder> collectFolders(TreeElement $this$collectFolders, Function1<? super MockFolder, Boolean> predicate) {
        List folders = new ArrayList();
        if ($this$collectFolders.getObj() instanceof MockFolder) {
            Object object = $this$collectFolders.getObj();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.btc.flowixsql.data.MockFolder");
            MockFolder mf = (MockFolder)object;
            if (((Boolean)predicate.invoke((Object)mf)).booleanValue()) {
                folders.add(mf);
            }
            Iterable $this$forEach$iv = $this$collectFolders.getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TreeElement it = (TreeElement)element$iv;
                boolean bl = false;
                folders.addAll((Collection)this.collectFolders(it, predicate));
            }
        }
        return folders;
    }

    private final List<Mock> collectMocks(TreeElement $this$collectMocks, Function1<? super Mock, Boolean> predicate) {
        List mocks = new ArrayList();
        Object object = $this$collectMocks.getObj();
        if (object instanceof Mock) {
            Object object2 = $this$collectMocks.getObj();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.btc.flowixsql.data.Mock");
            Mock mock = (Mock)object2;
            if (((Boolean)predicate.invoke((Object)mock)).booleanValue()) {
                mocks.add(mock);
            }
        } else if (object instanceof MockFolder) {
            Iterable $this$forEach$iv = $this$collectMocks.getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TreeElement it = (TreeElement)element$iv;
                boolean bl = false;
                mocks.addAll((Collection)this.collectMocks(it, predicate));
            }
        }
        return mocks;
    }

    private static final boolean saveMock$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ LoggerFacade access$getLog$p(MockServiceImpl $this) {
        return $this.log;
    }
}

