/*
 * Decompiled with CFR 0.152.
 */
package com.btc.flowixsql.services;

import com.btc.flowixsql.IJLogger;
import com.btc.flowixsql.LoggerFacade;
import com.btc.flowixsql.SoutLogger;
import com.btc.flowixsql.TopLevelKt;
import com.btc.flowixsql.actions.ToolbarState;
import com.btc.flowixsql.configuration.FlowixConfig;
import com.btc.flowixsql.configuration.Keys;
import com.btc.flowixsql.configuration.NetworkServerInstaller;
import com.btc.flowixsql.configuration.ResourceServerInstaller;
import com.btc.flowixsql.configuration.ServerInstaller;
import com.btc.flowixsql.data.serialization.FlowixConfigParser;
import com.btc.flowixsql.data.serialization.SnakeYamlReader;
import com.btc.flowixsql.data.serialization.VirtualFileAccessor;
import com.btc.flowixsql.data.serialization.YamlReader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001e\u001a\u00020\u001bH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\u0011\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\"\u00a2\u0006\u0002\u0010#J\u0006\u0010$\u001a\u00020 J\u0006\u0010%\u001a\u00020\u001bJ\b\u0010&\u001a\u00020\u001bH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\bR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/btc/flowixsql/services/ConfigService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "configPath", "", "getConfigPath", "()Ljava/lang/String;", "flowixConfig", "Lcom/btc/flowixsql/configuration/FlowixConfig;", "flowixFileName", "jarPath", "getJarPath", "logDirectory", "Ljava/io/File;", "getLogDirectory", "()Ljava/io/File;", "logger", "Lcom/btc/flowixsql/LoggerFacade;", "managePort", "", "getManagePort", "()I", "mockDirectory", "getMockDirectory", "networkInstaller", "", "yamlReader", "Lcom/btc/flowixsql/data/serialization/YamlReader;", "createConfigIfNotExists", "excludeFromIndexing", "", "getArguments", "", "()[Ljava/lang/String;", "installServer", "loadConfiguration", "loadFlowixConfig", "flowixsql"})
@SourceDebugExtension(value={"SMAP\nConfigService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigService.kt\ncom/btc/flowixsql/services/ConfigService\n+ 2 TopLevel.kt\ncom/btc/flowixsql/TopLevelKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,125:1\n72#2,4:126\n37#3,2:130\n1310#4,2:132\n*S KotlinDebug\n*F\n+ 1 ConfigService.kt\ncom/btc/flowixsql/services/ConfigService\n*L\n39#1:126,4\n121#1:130,2\n91#1:132,2\n*E\n"})
public final class ConfigService {
    @NotNull
    private final Project project;
    @NotNull
    private final String flowixFileName;
    @Nullable
    private FlowixConfig flowixConfig;
    @NotNull
    private final String configPath;
    @NotNull
    private final YamlReader yamlReader;
    private final boolean networkInstaller;
    @NotNull
    private final LoggerFacade logger;

    public ConfigService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.flowixFileName = "flowixsql.yaml";
        this.configPath = this.project.getBasePath() + "/.flowixsql";
        this.yamlReader = new SnakeYamlReader(new VirtualFileAccessor());
        this.networkInstaller = System.getenv("FX_NETWORK_INSTALLER") != null;
        ConfigService $this$getLogger$iv = this;
        boolean $i$f$getLogger = false;
        this.logger = ApplicationManager.getApplication() != null ? (LoggerFacade)new IJLogger(ConfigService.class) : (LoggerFacade)new SoutLogger(ConfigService.class);
        this.project.putUserData(Keys.INSTANCE.getFLOWIX_PATH(), (Object)this.configPath);
        this.project.putUserData(Keys.INSTANCE.getMOCK_PATH(), (Object)this.getMockDirectory());
        this.project.putUserData(Keys.INSTANCE.getTOOLBAR_STATE(), (Object)new ToolbarState(true, false));
    }

    @NotNull
    public final String getConfigPath() {
        return this.configPath;
    }

    @NotNull
    public final String getJarPath() {
        return this.configPath + "/flowixsql.jar";
    }

    public final int getManagePort() {
        FlowixConfig flowixConfig = this.flowixConfig;
        Intrinsics.checkNotNull((Object)flowixConfig);
        return flowixConfig.getManagePort();
    }

    @NotNull
    public final File getLogDirectory() {
        return new File(this.configPath + "/traces");
    }

    @NotNull
    public final File getMockDirectory() {
        return new File(this.configPath + "/mocks");
    }

    public final boolean loadConfiguration() {
        boolean configurationReady = this.createConfigIfNotExists() && this.loadFlowixConfig();
        FlowixConfig flowixConfig = this.flowixConfig;
        return (flowixConfig != null ? flowixConfig.getDebug() : false) ? false : configurationReady;
    }

    public final void installServer() {
        ServerInstaller installer = this.networkInstaller ? (ServerInstaller)new NetworkServerInstaller(this.project) : (ServerInstaller)new ResourceServerInstaller();
        installer.install(this.getJarPath());
    }

    private final boolean createConfigIfNotExists() {
        File flowixConfigFile;
        boolean result = true;
        String string = this.project.getBasePath();
        if (string == null) {
            return false;
        }
        String projectPath = string;
        File flowixDir = new File(projectPath, ".flowixsql");
        if (!flowixDir.exists()) {
            flowixDir.mkdirs();
            File dataDir = new File(flowixDir, "traces");
            File mocksDir = new File(flowixDir, "mocks");
            dataDir.mkdirs();
            mocksDir.mkdirs();
        }
        if (!(flowixConfigFile = new File(flowixDir, this.flowixFileName)).exists()) {
            result = TopLevelKt.writeTo("\n        targetHost: \"localhost\"\n        targetPort: 5432\n        localPort: 10001\n        managePort: 7777\n        filters: []\n        logLevel: INFO\n    ", flowixConfigFile);
            TopLevelKt.notifyInfo(this.project, "Created .flowixsql");
        }
        return result;
    }

    private final void excludeFromIndexing() {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.configPath);
        if (virtualFile == null) {
            throw new IllegalStateException(".flowixsql not found");
        }
        VirtualFile flowixDir = virtualFile;
        Module module = (Module)ArraysKt.firstOrNull((Object[])ModuleManager.Companion.getInstance(this.project).getModules());
        if (module == null) {
            return;
        }
        Module module2 = module;
        ApplicationManager.getApplication().runWriteAction(() -> ConfigService.excludeFromIndexing$lambda$1(module2, flowixDir));
    }

    private final boolean loadFlowixConfig() {
        Path path = Paths.get(this.configPath + "/" + this.flowixFileName, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path file = path;
        FlowixConfig flowixConfig = new FlowixConfigParser(this.yamlReader).parse(file);
        if (flowixConfig == null) {
            return false;
        }
        this.flowixConfig = flowixConfig;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String[] getArguments() {
        void $this$toTypedArray$iv;
        Collection collection;
        FlowixConfig flowixConfig;
        FlowixConfig flowixConfig2 = this.flowixConfig;
        if (flowixConfig2 == null) {
            throw new IllegalStateException("flowixConfig is not initialized");
        }
        FlowixConfig $this$getArguments_u24lambda_u243 = flowixConfig = flowixConfig2;
        boolean bl = false;
        List $this$getArguments_u24lambda_u243_u24lambda_u242 = collection = CollectionsKt.createListBuilder();
        boolean bl2 = false;
        $this$getArguments_u24lambda_u243_u24lambda_u242.add("-lp=" + $this$getArguments_u24lambda_u243.getLocalPort());
        $this$getArguments_u24lambda_u243_u24lambda_u242.add("-tp=" + $this$getArguments_u24lambda_u243.getTargetPort());
        $this$getArguments_u24lambda_u243_u24lambda_u242.add("-mp=" + $this$getArguments_u24lambda_u243.getManagePort());
        $this$getArguments_u24lambda_u243_u24lambda_u242.add("-th=" + $this$getArguments_u24lambda_u243.getTargetHost());
        $this$getArguments_u24lambda_u243_u24lambda_u242.add("--mock-path=" + this.getMockDirectory().getPath());
        $this$getArguments_u24lambda_u243_u24lambda_u242.add("--trace-path=" + this.getLogDirectory().getPath());
        if (!((Collection)flowixConfig.getFilters()).isEmpty()) {
            $this$getArguments_u24lambda_u243_u24lambda_u242.add("-filters=" + CollectionsKt.joinToString$default((Iterable)flowixConfig.getFilters(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        $this$getArguments_u24lambda_u243_u24lambda_u242.add("-ll=" + $this$getArguments_u24lambda_u243.getLogLevel());
        $this$getArguments_u24lambda_u243_u24lambda_u242.add("--disable-force-exit");
        collection = CollectionsKt.build((List)collection);
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    /*
     * Unable to fully structure code
     */
    private static final void excludeFromIndexing$lambda$1(Module $module, VirtualFile $flowixDir) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
            Intrinsics.checkNotNullParameter((Object)$flowixDir, (String)"$flowixDir");
            v0 = ModuleRootManager.getInstance((Module)$module).getModifiableModel();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getModifiableModel(...)");
            modifiableModel = v0;
            v1 = modifiableModel.getContentEntries();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getContentEntries(...)");
            $this$firstOrNull$iv = v1;
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                contentEntry = (ContentEntry)element$iv;
                $i$a$-firstOrNull-ConfigService$excludeFromIndexing$1$contentEntry$1 = false;
                if (contentEntry.getFile() == null) ** GOTO lbl-1000
                v2 = $flowixDir.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getPath(...)");
                v3 = contentEntry.getFile();
                Intrinsics.checkNotNull((Object)v3);
                v4 = v3.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getPath(...)");
                if (StringsKt.startsWith$default((String)v2, (String)v4, (boolean)false, (int)2, null)) {
                    v5 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = false;
                }
                if (!v5) continue;
                v6 = element$iv;
                break block5;
            }
            v6 = null;
        }
        contentEntry = (ContentEntry)v6;
        if (contentEntry != null) {
            contentEntry.addExcludeFolder($flowixDir);
            modifiableModel.commit();
        } else {
            modifiableModel.dispose();
        }
    }
}

