/*
 * Decompiled with CFR 0.152.
 */
package com.btc.flowixsql.data.serialization;

import com.btc.flowixsql.data.serialization.FileAccessor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lcom/btc/flowixsql/data/serialization/NioFileAccessor;", "Lcom/btc/flowixsql/data/serialization/FileAccessor;", "()V", "createFile", "Ljava/nio/file/Path;", "path", "", "fileName", "getContent", "writeContentToFile", "", "content", "flowixsql"})
public final class NioFileAccessor
implements FileAccessor {
    @Override
    @NotNull
    public String getContent(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = Files.readString(path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        return string;
    }

    @Override
    @NotNull
    public Path createFile(@NotNull String path, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Path path2 = Files.createFile(Paths.get(path, new String[0]).resolve(fileName), new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createFile(...)");
        return path2;
    }

    @Override
    public void writeContentToFile(@NotNull Path path, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Files.writeString(path, (CharSequence)content, new OpenOption[0]);
    }

    @Override
    @NotNull
    public Path createDirs(@NotNull String fullPath) {
        return FileAccessor.DefaultImpls.createDirs(this, fullPath);
    }
}

