/*
 * Decompiled with CFR 0.152.
 */
package com.btc.flowixsql.services;

import com.btc.flowixsql.IJLogger;
import com.btc.flowixsql.LoggerFacade;
import com.btc.flowixsql.SoutLogger;
import com.btc.flowixsql.TopLevelKt;
import com.btc.flowixsql.data.Mock;
import com.btc.flowixsql.data.MockFolder;
import com.btc.flowixsql.data.serialization.VirtualFileAccessor;
import com.btc.flowixsql.listeners.Topics;
import com.btc.flowixsql.services.ConfigService;
import com.btc.flowixsql.services.ManagerService;
import com.btc.flowixsql.services.MockService;
import com.btc.flowixsql.services.MockServiceImpl;
import com.btc.flowixsql.ui.TreeElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ\u0016\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001aJ\u000e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ\u0016\u0010 \u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001aJ\u000e\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001eJ\u000e\u0010#\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u001eJ\u0010\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u001eH\u0002J\u000e\u0010&\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010'\u001a\u00020\u0015J\b\u0010(\u001a\u00020\u0015H\u0002J\u0006\u0010)\u001a\u00020\u0015J\u000e\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u001aJ\u0016\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u001aJ\u0012\u0010/\u001a\b\u0012\u0004\u0012\u00020100*\u00020\u001aH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00062"}, d2={"Lcom/btc/flowixsql/services/FlowixService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "configService", "Lcom/btc/flowixsql/services/ConfigService;", "logger", "Lcom/btc/flowixsql/LoggerFacade;", "managerService", "Lcom/btc/flowixsql/services/ManagerService;", "mockService", "Lcom/btc/flowixsql/services/MockServiceImpl;", "process", "Ljava/lang/Process;", "<set-?>", "", "ready", "getReady", "()Z", "deleteMock", "", "mock", "Lcom/btc/flowixsql/data/Mock;", "dispose", "loadMocks", "Lcom/btc/flowixsql/ui/TreeElement;", "root", "loadMocksIfRequired", "changedFile", "", "loadTraces", "loadTracesIfRequired", "newFolder", "nodePath", "newMock", "reloadVirtualFile", "path", "saveMock", "start", "startServer", "stop", "switchState", "el", "updateMockTree", "message", "node", "collectMockIds", "", "Ljava/util/UUID;", "flowixsql"})
@SourceDebugExtension(value={"SMAP\nFlowixService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlowixService.kt\ncom/btc/flowixsql/services/FlowixService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 TopLevel.kt\ncom/btc/flowixsql/TopLevelKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n31#2,2:170\n31#2,2:172\n72#3,4:174\n1368#4:178\n1454#4,5:179\n*S KotlinDebug\n*F\n+ 1 FlowixService.kt\ncom/btc/flowixsql/services/FlowixService\n*L\n28#1:170,2\n29#1:172,2\n32#1:174,4\n156#1:178\n156#1:179,5\n*E\n"})
public final class FlowixService
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final ConfigService configService;
    @NotNull
    private final ManagerService managerService;
    @NotNull
    private final MockServiceImpl mockService;
    @Nullable
    private Process process;
    @NotNull
    private final LoggerFacade logger;
    private boolean ready;

    public FlowixService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class serviceClass$iv = ConfigService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.configService = (ConfigService)object;
        $this$service$iv = (ComponentManager)this.project;
        $i$f$service = false;
        serviceClass$iv = ManagerService.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.managerService = (ManagerService)object2;
        this.mockService = new MockServiceImpl(new VirtualFileAccessor());
        FlowixService $this$getLogger$iv = this;
        boolean $i$f$getLogger = false;
        this.logger = ApplicationManager.getApplication() != null ? (LoggerFacade)new IJLogger(FlowixService.class) : (LoggerFacade)new SoutLogger(FlowixService.class);
        this.logger.warn("Initializing FlowixService");
        MessageBusConnection $this$_init__u24lambda_u242 = this.project.getMessageBus().connect();
        boolean bl = false;
        $this$_init__u24lambda_u242.subscribe(Topics.INSTANCE.getAPP_CONNECTED(), () -> FlowixService.lambda$2$lambda$0(this));
        $this$_init__u24lambda_u242.subscribe(Topics.INSTANCE.getAPP_DISCONNECTED(), () -> FlowixService.lambda$2$lambda$1(this));
    }

    public final boolean getReady() {
        return this.ready;
    }

    public final void start() {
        boolean clientReady = this.configService.initialize();
        if (clientReady) {
            this.startServer();
        }
    }

    private final void startServer() {
        String jarPath = this.configService.getJarPath();
        String[] stringArray = new String[]{"bin", "java"};
        String javaBin = ((Object)Paths.get(System.getProperty("java.home"), stringArray)).toString();
        SpreadBuilder spreadBuilder = new SpreadBuilder(4);
        spreadBuilder.add((Object)javaBin);
        spreadBuilder.add((Object)"-jar");
        spreadBuilder.add((Object)jarPath);
        spreadBuilder.addSpread((Object)this.configService.getArguments());
        ProcessBuilder pb = new ProcessBuilder((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
        boolean devMode = Intrinsics.areEqual((Object)System.getenv("FLOWIXSQL_DEV_MODE"), (Object)"on");
        if (devMode) {
            pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        }
        pb.directory(new File(this.configService.getConfigPath()));
        this.process = pb.start();
        Thread printingHook = new Thread(() -> FlowixService.startServer$lambda$3(this));
        Runtime.getRuntime().addShutdownHook(printingHook);
    }

    public final void stop() {
        block0: {
            TopLevelKt.submitEvent(this.project, Topics.INSTANCE.getMOCK_TREE_CLEARING_EVENT());
            Process process = this.process;
            if (process == null) break block0;
            process.destroy();
        }
    }

    public final void updateMockTree(@NotNull String message, @NotNull TreeElement node) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.mockService.updateMockTree(message, node);
    }

    @NotNull
    public final TreeElement loadMocks(@NotNull TreeElement root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return this.mockService.loadMocks(root, this.configService.getMockDirectory());
    }

    @NotNull
    public final TreeElement loadMocksIfRequired(@NotNull String changedFile, @NotNull TreeElement root) {
        TreeElement treeElement;
        Intrinsics.checkNotNullParameter((Object)changedFile, (String)"changedFile");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        if (this.configService.getMockDirectory() == null) {
            treeElement = root;
        } else {
            File file = this.configService.getMockDirectory();
            Intrinsics.checkNotNull((Object)file);
            treeElement = this.mockService.loadMocksIfRequired(changedFile, root, file);
        }
        return treeElement;
    }

    @NotNull
    public final TreeElement loadTraces(@NotNull TreeElement root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return this.mockService.loadTraces(root, this.configService.getLogDirectory());
    }

    @NotNull
    public final TreeElement loadTracesIfRequired(@NotNull String changedFile, @NotNull TreeElement root) {
        TreeElement treeElement;
        Intrinsics.checkNotNullParameter((Object)changedFile, (String)"changedFile");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        if (this.configService.getLogDirectory() == null) {
            treeElement = root;
        } else {
            File file = this.configService.getLogDirectory();
            Intrinsics.checkNotNull((Object)file);
            treeElement = this.mockService.loadTracesIfRequired(changedFile, root, file);
        }
        return treeElement;
    }

    public final void saveMock(@NotNull Mock mock) {
        Intrinsics.checkNotNullParameter((Object)mock, (String)"mock");
        this.mockService.saveMock(mock);
        this.reloadVirtualFile(((Object)mock.getFullMockPath()).toString());
        if (!Intrinsics.areEqual((Object)mock.getFullMockPath(), (Object)mock.getStartFullMockPath())) {
            this.reloadVirtualFile(((Object)mock.getStartFullMockPath()).toString());
        }
        TopLevelKt.notifyInfo(this.project, "Saved " + mock.getMockFileName());
    }

    public final void deleteMock(@NotNull Mock mock) {
        Intrinsics.checkNotNullParameter((Object)mock, (String)"mock");
        MockService.DeletingResult result = this.mockService.deleteMock(mock);
        switch (WhenMappings.$EnumSwitchMapping$0[result.ordinal()]) {
            case 1: {
                TopLevelKt.notifyInfo(this.project, "Saved " + mock.getMockFileName());
                this.reloadVirtualFile(((Object)mock.getStartFullMockPath()).toString());
                break;
            }
            case 2: {
                TopLevelKt.notifyInfo(this.project, "Deleted " + mock.getMockFileName());
            }
        }
        this.logger.info("removed mock: " + mock.getId());
    }

    @NotNull
    public final Mock newMock(@NotNull String nodePath2) {
        Intrinsics.checkNotNullParameter((Object)nodePath2, (String)"nodePath");
        File file = this.configService.getMockDirectory();
        String path = (file != null ? file.getParent() : null) + "/" + nodePath2;
        return this.mockService.newMock(path);
    }

    @NotNull
    public final String newFolder(@NotNull String nodePath2) {
        Intrinsics.checkNotNullParameter((Object)nodePath2, (String)"nodePath");
        File file = this.configService.getMockDirectory();
        Intrinsics.checkNotNull((Object)file);
        String string = file.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParent(...)");
        return this.mockService.newMockDir(string, nodePath2);
    }

    private final void reloadVirtualFile(String path) {
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl("file://" + path);
        if (virtualFile != null) {
            ApplicationManager.getApplication().invokeLater(() -> FlowixService.reloadVirtualFile$lambda$5(virtualFile));
        }
    }

    @NotNull
    public final TreeElement switchState(@NotNull TreeElement el) {
        Intrinsics.checkNotNullParameter((Object)el, (String)"el");
        if (!(el.getObj() instanceof MockFolder)) {
            throw new IllegalArgumentException("This type not supported");
        }
        Object object = el.getObj();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.btc.flowixsql.data.MockFolder");
        boolean enable = ((MockFolder)object).getEnabled();
        TreeElement changedElement = this.mockService.switchState(el);
        List<UUID> ids2 = this.collectMockIds(changedElement);
        if (enable) {
            this.managerService.disableMocks(ids2);
        } else {
            this.managerService.enableMocks(ids2);
        }
        return changedElement;
    }

    /*
     * WARNING - void declaration
     */
    private final List<UUID> collectMockIds(TreeElement $this$collectMockIds) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$collectMockIds.getChildren();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            TreeElement el = (TreeElement)element$iv$iv;
            boolean bl = false;
            Object object = el.getObj();
            if (object instanceof Mock) {
                Object object2 = el.getObj();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.btc.flowixsql.data.Mock");
                list = CollectionsKt.listOf((Object)((Mock)object2).getId());
            } else if (object instanceof MockFolder) {
                list = this.collectMockIds(el);
            } else {
                throw new IllegalArgumentException("Unsupported node type");
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public void dispose() {
    }

    private static final void lambda$2$lambda$0(FlowixService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.ready = true;
    }

    private static final void lambda$2$lambda$1(FlowixService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.ready = false;
    }

    private static final void startServer$lambda$3(FlowixService this$0) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.logger.info("Destroying the server process...");
            Process process = this$0.process;
            if (process == null) break block0;
            process.destroy();
        }
    }

    private static final void reloadVirtualFile$lambda$5$lambda$4(VirtualFile $virtualFile) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager docManager = fileDocumentManager;
        Document document = docManager.getCachedDocument($virtualFile);
        if (document != null) {
            docManager.reloadFromDisk(document);
        }
        $virtualFile.refresh(false, false);
    }

    private static final void reloadVirtualFile$lambda$5(VirtualFile $virtualFile) {
        ApplicationManager.getApplication().runWriteAction(() -> FlowixService.reloadVirtualFile$lambda$5$lambda$4($virtualFile));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MockService.DeletingResult.values().length];
            try {
                nArray[MockService.DeletingResult.FILE_SAVED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MockService.DeletingResult.FILE_DELETED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

