/*
 * Decompiled with CFR 0.152.
 */
package com.btc.flowixsql.data.serialization;

import com.btc.flowixsql.configuration.FlowixConfig;
import com.btc.flowixsql.data.serialization.MapExtensionsKt;
import com.btc.flowixsql.data.serialization.MapYamlParsersKt;
import com.btc.flowixsql.data.serialization.YamlParser;
import com.btc.flowixsql.data.serialization.YamlReader;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/btc/flowixsql/data/serialization/FlowixConfigParser;", "Lcom/btc/flowixsql/data/serialization/YamlParser;", "Lcom/btc/flowixsql/configuration/FlowixConfig;", "reader", "Lcom/btc/flowixsql/data/serialization/YamlReader;", "(Lcom/btc/flowixsql/data/serialization/YamlReader;)V", "parse", "path", "Ljava/nio/file/Path;", "flowixsql"})
public final class FlowixConfigParser
implements YamlParser<FlowixConfig> {
    @NotNull
    private final YamlReader reader;

    public FlowixConfigParser(@NotNull YamlReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.reader = reader;
    }

    @Override
    @Nullable
    public FlowixConfig parse(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Map<String, Object> map = MapYamlParsersKt.safeReadMap(this.reader, path);
        if (map == null) {
            return null;
        }
        Map<String, Object> configMap = map;
        return new FlowixConfig(MapExtensionsKt.getStringValueStrict(configMap, "flowixPath"), MapExtensionsKt.getStringValueStrict(configMap, "mocksDirPath"), MapExtensionsKt.getStringValueStrict(configMap, "targetHost"), MapExtensionsKt.getIntValue(configMap, "targetPort", 5432), MapExtensionsKt.getIntValue(configMap, "localPort", 10001), MapExtensionsKt.getIntValue(configMap, "managePort", 7777), MapExtensionsKt.getStringValueStrict(configMap, "logLevel"), MapExtensionsKt.getBooleanValue(configMap, "debug", false));
    }
}

