/*
 * Decompiled with CFR 0.152.
 */
package com.btc.flowixsql.services;

import com.btc.flowixsql.IJLogger;
import com.btc.flowixsql.LoggerFacade;
import com.btc.flowixsql.SoutLogger;
import com.btc.flowixsql.TopLevelKt;
import com.btc.flowixsql.configuration.FlowixConfig;
import com.btc.flowixsql.configuration.Keys;
import com.btc.flowixsql.configuration.ManageConfig;
import com.btc.flowixsql.data.serialization.FlowixConfigParser;
import com.btc.flowixsql.data.serialization.ManageConfigParser;
import com.btc.flowixsql.data.serialization.SnakeYamlReader;
import com.btc.flowixsql.data.serialization.VirtualFileAccessor;
import com.btc.flowixsql.data.serialization.YamlReader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020$H\u0002J\u0011\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00060'\u00a2\u0006\u0002\u0010(J\u0006\u0010)\u001a\u00020\"J\b\u0010*\u001a\u00020\"H\u0002J\b\u0010+\u001a\u00020\"H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/btc/flowixsql/services/ConfigService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "configPath", "", "getConfigPath", "()Ljava/lang/String;", "flowixConfig", "Lcom/btc/flowixsql/configuration/FlowixConfig;", "flowixFileName", "jarLocationHost", "jarLocationPort", "", "jarPath", "getJarPath", "logDirectory", "Ljava/io/File;", "getLogDirectory", "()Ljava/io/File;", "logger", "Lcom/btc/flowixsql/LoggerFacade;", "manageConfig", "Lcom/btc/flowixsql/configuration/ManageConfig;", "manageFileName", "managePort", "getManagePort", "()I", "mockDirectory", "getMockDirectory", "yamlReader", "Lcom/btc/flowixsql/data/serialization/YamlReader;", "createConfigIfNotExists", "", "downloadServerJar", "", "excludeFromIndexing", "getArguments", "", "()[Ljava/lang/String;", "initialize", "loadFlowixConfig", "loadManageConfig", "flowixsql"})
@SourceDebugExtension(value={"SMAP\nConfigService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigService.kt\ncom/btc/flowixsql/services/ConfigService\n+ 2 TopLevel.kt\ncom/btc/flowixsql/TopLevelKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,160:1\n72#2,4:161\n1#3:165\n1310#4,2:166\n*S KotlinDebug\n*F\n+ 1 ConfigService.kt\ncom/btc/flowixsql/services/ConfigService\n*L\n40#1:161,4\n93#1:166,2\n*E\n"})
public final class ConfigService {
    @NotNull
    private final Project project;
    @NotNull
    private final String flowixFileName;
    @NotNull
    private final String manageFileName;
    @Nullable
    private FlowixConfig flowixConfig;
    @Nullable
    private ManageConfig manageConfig;
    @NotNull
    private final String configPath;
    @NotNull
    private final YamlReader yamlReader;
    @NotNull
    private final String jarLocationHost;
    private final int jarLocationPort;
    @NotNull
    private final LoggerFacade logger;

    public ConfigService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.flowixFileName = "flowixsql.yaml";
        this.manageFileName = "manage.yaml";
        this.configPath = this.project.getBasePath() + "/.flowixsql";
        this.yamlReader = new SnakeYamlReader(new VirtualFileAccessor());
        String string = System.getenv("JAR_LOCATION_HOST");
        if (string == null) {
            string = "localhost";
        }
        this.jarLocationHost = string;
        String string2 = System.getenv("JAR_LOCATION_PORT");
        this.jarLocationPort = string2 != null ? Integer.parseInt(string2) : 8000;
        ConfigService $this$getLogger$iv = this;
        boolean $i$f$getLogger = false;
        this.logger = ApplicationManager.getApplication() != null ? (LoggerFacade)new IJLogger(ConfigService.class) : (LoggerFacade)new SoutLogger(ConfigService.class);
        this.project.putUserData(Keys.INSTANCE.getFLOWIX_PATH(), (Object)this.configPath);
    }

    @NotNull
    public final String getConfigPath() {
        return this.configPath;
    }

    @NotNull
    public final String getJarPath() {
        FlowixConfig flowixConfig = this.flowixConfig;
        Intrinsics.checkNotNull((Object)flowixConfig);
        return this.configPath + "/" + flowixConfig.getFlowixPath();
    }

    public final int getManagePort() {
        FlowixConfig flowixConfig = this.flowixConfig;
        Intrinsics.checkNotNull((Object)flowixConfig);
        return flowixConfig.getManagePort();
    }

    @Nullable
    public final File getLogDirectory() {
        File file;
        Object object = this.manageConfig;
        if (object != null && (object = ((ManageConfig)object).getLogPath()) != null) {
            Object it = object;
            boolean bl = false;
            file = new File(this.configPath + "/" + (String)it);
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getMockDirectory() {
        File file;
        Object object = this.flowixConfig;
        if (object != null && (object = ((FlowixConfig)object).getMocksDirPath()) != null) {
            Object it = object;
            boolean bl = false;
            file = new File(this.configPath + "/" + (String)it);
        } else {
            file = null;
        }
        return file;
    }

    public final boolean initialize() {
        boolean configurationReady = this.createConfigIfNotExists() && this.loadFlowixConfig() && this.loadManageConfig();
        FlowixConfig flowixConfig = this.flowixConfig;
        boolean bl = flowixConfig != null ? flowixConfig.getDebug() : false;
        if (bl) {
            return false;
        }
        this.downloadServerJar();
        return configurationReady;
    }

    private final boolean createConfigIfNotExists() {
        boolean result = true;
        String string = this.project.getBasePath();
        if (string == null) {
            return false;
        }
        String projectPath = string;
        File flowixDir = new File(projectPath, ".flowixsql");
        if (!flowixDir.exists()) {
            flowixDir.mkdirs();
            File dataDir = new File(flowixDir, "data");
            File mocksDir = new File(flowixDir, "mocks");
            dataDir.mkdirs();
            mocksDir.mkdirs();
        }
        File flowixConfigFile = new File(flowixDir, this.flowixFileName);
        File manageConfigFile = new File(flowixDir, this.manageFileName);
        if (!flowixConfigFile.exists()) {
            result = TopLevelKt.writeTo("\n        flowixPath: \"flowixsql.jar\"\n        mocksDirPath: \"mocks\"\n        targetHost: \"localhost\"\n        targetPort: 5432\n        localPort: 10001\n        managePort: 7777\n        logLevel: INFO\n    ", flowixConfigFile);
            TopLevelKt.notifyInfo(this.project, "Created .flowixsql");
        }
        if (!manageConfigFile.exists()) {
            result = TopLevelKt.writeTo("\n        logPath: \"data\"\n        filters: []\n    ", manageConfigFile);
        }
        return result;
    }

    private final void excludeFromIndexing() {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.configPath);
        if (virtualFile == null) {
            throw new IllegalStateException(".flowixsql not found");
        }
        VirtualFile flowixDir = virtualFile;
        Module module = (Module)ArraysKt.firstOrNull((Object[])ModuleManager.Companion.getInstance(this.project).getModules());
        if (module == null) {
            return;
        }
        Module module2 = module;
        ApplicationManager.getApplication().runWriteAction(() -> ConfigService.excludeFromIndexing$lambda$3(module2, flowixDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void downloadServerJar() {
        if (!new File(this.getJarPath()).exists()) {
            Closeable closeable = (Closeable)HttpClients.createDefault();
            Throwable throwable = null;
            try {
                boolean response22;
                CloseableHttpClient it = (CloseableHttpClient)closeable;
                boolean bl = false;
                File jarFile = new File(this.configPath + "/flowixsql.jar");
                FileOutputStream out = new FileOutputStream(jarFile);
                try {
                    boolean bl2;
                    CloseableHttpResponse response22 = it.execute(new HttpHost(this.jarLocationHost, this.jarLocationPort), (HttpRequest)new HttpGet("/file"));
                    if (response22.getStatusLine().getStatusCode() == 200) {
                        response22.getEntity().writeTo((OutputStream)out);
                        out.close();
                        bl2 = true;
                    } else {
                        bl2 = false;
                    }
                    response22 = bl2;
                }
                catch (Exception e) {
                    this.logger.warn("Failed to connect to server at " + this.jarLocationHost + ":" + this.jarLocationPort);
                    response22 = false;
                }
                boolean result = response22;
                if (!result) {
                    String errMsg = "Failed to load a server JAR file to path: " + this.getJarPath();
                    this.logger.warn(errMsg);
                    TopLevelKt.notifyError(this.project, errMsg);
                    out.close();
                    jarFile.delete();
                    return;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    private final boolean loadFlowixConfig() {
        Path path = Paths.get(this.configPath + "/" + this.flowixFileName, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path file = path;
        FlowixConfig flowixConfig = new FlowixConfigParser(this.yamlReader).parse(file);
        if (flowixConfig == null) {
            return false;
        }
        this.flowixConfig = flowixConfig;
        this.project.putUserData(Keys.INSTANCE.getFLOWIX_CONFIG(), (Object)this.flowixConfig);
        return true;
    }

    private final boolean loadManageConfig() {
        String string = this.configPath;
        String[] stringArray = new String[]{this.manageFileName};
        Path path = Paths.get(string, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path file = path;
        ManageConfig manageConfig = new ManageConfigParser(this.yamlReader).parse(file);
        if (manageConfig == null) {
            return false;
        }
        this.manageConfig = manageConfig;
        return true;
    }

    @NotNull
    public final String[] getArguments() {
        FlowixConfig flowixConfig;
        FlowixConfig flowixConfig2 = this.flowixConfig;
        if (flowixConfig2 == null) {
            throw new IllegalStateException("flowixConfig is not initialized");
        }
        FlowixConfig $this$getArguments_u24lambda_u245 = flowixConfig = flowixConfig2;
        boolean bl = false;
        String[] stringArray = new String[]{"-lp=" + $this$getArguments_u24lambda_u245.getLocalPort(), "-tp=" + $this$getArguments_u24lambda_u245.getTargetPort(), "-mp=" + $this$getArguments_u24lambda_u245.getManagePort(), "-th=" + $this$getArguments_u24lambda_u245.getTargetHost(), "-path=" + this.configPath + "/" + $this$getArguments_u24lambda_u245.getMocksDirPath(), "-mf=" + this.configPath + "/" + this.manageFileName, "-ll=" + $this$getArguments_u24lambda_u245.getLogLevel()};
        return stringArray;
    }

    /*
     * Unable to fully structure code
     */
    private static final void excludeFromIndexing$lambda$3(Module $module, VirtualFile $flowixDir) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
            Intrinsics.checkNotNullParameter((Object)$flowixDir, (String)"$flowixDir");
            v0 = ModuleRootManager.getInstance((Module)$module).getModifiableModel();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getModifiableModel(...)");
            modifiableModel = v0;
            v1 = modifiableModel.getContentEntries();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getContentEntries(...)");
            $this$firstOrNull$iv = v1;
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                contentEntry = (ContentEntry)element$iv;
                $i$a$-firstOrNull-ConfigService$excludeFromIndexing$1$contentEntry$1 = false;
                if (contentEntry.getFile() == null) ** GOTO lbl-1000
                v2 = $flowixDir.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getPath(...)");
                v3 = contentEntry.getFile();
                Intrinsics.checkNotNull((Object)v3);
                v4 = v3.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getPath(...)");
                if (StringsKt.startsWith$default((String)v2, (String)v4, (boolean)false, (int)2, null)) {
                    v5 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = false;
                }
                if (!v5) continue;
                v6 = element$iv;
                break block5;
            }
            v6 = null;
        }
        contentEntry = (ContentEntry)v6;
        if (contentEntry != null) {
            contentEntry.addExcludeFolder($flowixDir);
            modifiableModel.commit();
        } else {
            modifiableModel.dispose();
        }
    }
}

